public class Metropolis implements MatrixError{
    private MersenneTwisterFast randGen;

    private double errConst; 
    private boolean hasErrConst = false;
    private MatrixErrorMeasure matError;
    private LocalModificator localMod;  
       
    //Support permutations
    public Metropolis(double errConst, MatrixErrorMeasure matError) { this.setErrConst(errConst); this.matError = matError; }
    public Metropolis(MatrixErrorMeasure matError, double errConst) { this(errConst, matError); }   
 
    //Support default values for all input parameters
    public Metropolis(double errConst) { this.setErrConst(errConst); setDefaultMatError(); }
    public Metropolis(MatrixErrorMeasure matError) { this.matError = matError; } 
    public Metropolis() { setDefaultMatError(); };
        
    public void init(double[][] startMatrix, double[][] origMatrix, LocalModificator localMod, MersenneTwisterFast randGen) {
        if(hasErrConst == false)
            throw new RuntimeException("Error: ErrConst has not been initialized.");        
        
        this.randGen = randGen;
        
        matError.init(origMatrix, startMatrix, localMod);
        this.localMod = localMod; 
    }
    
    public boolean acceptModification(){        
        if(Math.log(randGen.nextDouble()) < -errConst * matError.update())
            return true;
        else{
            localMod.deselect();  //the order of these two lines is important!
            matError.update();
            return false;
        }
    }                 
    
    public String getParams() { return "" + errConst; }
        
    //Auxiliary methods for default input parameters
    public void setErrConst(double errConst){
        this.errConst = errConst;
        this.hasErrConst = true;
    }
    
    public boolean hasErrConst() { return hasErrConst; }
    public double getErrConst() { return errConst; }
    public MatrixErrorMeasure getMatrixErrorMeasure() { return matError; }
    
    private void setDefaultMatError() { this.matError = new ErrCdfHist(); }   
}
