import java.util.Iterator;

public abstract class LocalModificator implements Iterable<LocalModificatorElement>, Cloneable{    
    protected MersenneTwisterFast randGen;
    protected double[][] A;
    protected int rs, cs, size; 
    protected boolean hasParams = true;
    protected boolean cloneSupported = true;
    
    public void init(double[][] A) { 
        this.A = A; rs = A.length; cs = A[0].length; size = rs * cs;
        cloneSupported = false;
        if(hasParams == false)
            throw new RuntimeException("Parameters for local modification has not been initialized.");
    }
    
    public Object clone() throws CloneNotSupportedException {
        if(!cloneSupported)
            throw new CloneNotSupportedException("Cloning is not yet supported after initialization");
        return super.clone();
    }
    
    public void setRandGen(MersenneTwisterFast randGen) { this.randGen = randGen; }
    
    public double[][] getRandomizedMatrix() { return A; }
     
    public abstract boolean select(); //returns true, if range ok
    public abstract void perform();
    public abstract void deselect();
    
    public boolean hasParams() { return hasParams; }
    public String getParams() { return ""; }
    
    //this returns an iterator over the modified elements
    public abstract Iterator<LocalModificatorElement> iterator();
}    
