import java.util.Arrays;

public class ErrCdf extends MatrixErrorMeasure{    
    private double[][] colVals, rowVals, origColVals, origRowVals;    
    
    public void init(double[][] origMatrix, double[][] startMatrix, LocalModificator localMod){
        super.init(origMatrix, startMatrix, localMod);
                
        rowVals = new double[rs][cs];
        colVals = new double[cs][rs];
        origRowVals = new double[rs][cs];
        origColVals = new double[cs][rs];
        
        initVals(startMatrix, rowVals, colVals);
        initVals(origMatrix, origRowVals, origColVals);
    }
    
    private void initVals(double[][] A, double[][] R, double[][] C){
        for(int row = 0; row < rs; ++row)
            for(int col = 0; col < cs; ++col)
                C[col][row] = R[row][col] = A[row][col];

        for(double[] r : R)
            Arrays.sort(r);
        
        for(double[] c : C)
            Arrays.sort(c);        
    }
    
    public double update(){
        double errDiff = 0;                
        for(LocalModificatorElement e : localMod){            
            errDiff += changeSingleValue(rowVals[e.row], origRowVals[e.row], e.oldVal, e.newVal);
            errDiff += changeSingleValue(colVals[e.col], origColVals[e.col], e.oldVal, e.newVal);
        }
        return errDiff;
    }
           
    private double changeSingleValue(double[] vals, double[] origVals, double oldVal, double newVal){        
        int i = Arrays.binarySearch(vals, oldVal);
        double error = 0;
        if(newVal>oldVal){
            while(i+1<vals.length && vals[i+1] < newVal){
                error += Math.abs(origVals[i]-vals[i+1]) - Math.abs(origVals[i]-vals[i]);
                vals[i] = vals[i+1];
                i++;
            }
        } else{
            while(i>0 && vals[i-1] > newVal){
                error += Math.abs(origVals[i]-vals[i-1]) - Math.abs(origVals[i]-vals[i]);
                vals[i] = vals[i-1];
                i--;
            }
        }
        error += Math.abs(origVals[i]-newVal) - Math.abs(origVals[i]-vals[i]);
        vals[i] = newVal;
        return error;
    }
}
