public abstract class MatrixErrorMeasure implements Cloneable{   
    protected int rs, cs;    
    protected LocalModificator localMod;
    protected boolean hasParams = true;    
    private boolean cloneSupported = true;    
    
    public abstract double update();
    
    public boolean hasParams() { return hasParams; }
    public String getParams() { return ""; }
    
    public void init(double[][] origMatrix, double[][] startMatrix, LocalModificator localMod) { 
        rs = startMatrix.length;
        cs = startMatrix[0].length;
        this.localMod = localMod;
        
        cloneSupported = false;
        
        if(hasParams == false)
            throw new RuntimeException("Parameters for MatrixErrorMeasure has not been initialized.");
    }   
    
    public Object clone() throws CloneNotSupportedException {
        if(!cloneSupported)
            throw new CloneNotSupportedException("Cloning is not yet supported after initialization");
        return super.clone();
    }
}
