import java.util.Iterator;

public abstract class LocalModificatorQuartet extends LocalModificator{
    protected int[] rows = new int[2];
    protected int[] cols = new int[2];
    protected double[][] oldVals = new double[2][2];
    protected double[][] newVals = new double[2][2];

    protected void selectElements(){
        int corner = randGen.nextInt(size);
        cols[0] = corner / rs;
        rows[0] = corner % rs;        
        do{
            corner = randGen.nextInt(size);
            cols[1] = corner / rs;
            rows[1] = corner % rs;
        } while(cols[0] == cols[1] || rows[0] == rows[1]);
        
        for(int row = 0; row<2; row++)
            for(int col = 0; col<2; col++)
                oldVals[row][col] = A[rows[row]][cols[col]];
    }
    
    public void perform(){
        for(int row = 0; row<2; row++)
            for(int col = 0; col<2; col++)
                A[rows[row]][cols[col]] = newVals[row][col];
    }
    
    public void deselect(){
        double[][] t = newVals;
        newVals = oldVals;
        oldVals = t;
    }
    
    public Iterator<LocalModificatorElement> iterator(){
        return new LocalModificatorIterator();
    }
    
    private class LocalModificatorIterator implements Iterator<LocalModificatorElement>{
        int r=0, c=-1;
        
        public boolean hasNext() { return r < 1 || c < 1; }
        
        public LocalModificatorElement next(){
            c++;
            if(c == 2){
                c = 0;
                r++;
            }
            return new LocalModificatorElement(rows[r], cols[c], oldVals[r][c], newVals[r][c]);
        }        
        
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }     
}    
