public class RandomizeMatrix{
    private int realChanges, attempts;
    private LocalModificator localMod;
    
    public int getRealChanges() { return realChanges; }
    public int getAttempts() { return attempts; }
    public double getAcceptanceRate() { return realChanges/(double)attempts; }    
    public double[][] getRandomizedMatrix() { return localMod.getRandomizedMatrix(); }
        
    public RandomizeMatrix(double[][] startMatrix, double[][] origMatrix, int attempts, LocalModificator localMod, MatrixError matError, MersenneTwisterFast randGen){
        this.attempts = attempts;
        this.localMod = localMod;

        localMod.init(startMatrix); 
        localMod.setRandGen(randGen);
        matError.init(startMatrix, origMatrix, localMod, randGen);
                  
        for(int attempt = 0; attempt < attempts; ++attempt) {
            if(localMod.select()){
                if(matError.acceptModification()){                
                    localMod.perform();
                    ++realChanges;
                }
            }
        }
    }    
}
