import java.util.Iterator;

public abstract class LocalModificatorSingle extends LocalModificator{
    protected int row, col;
    protected double oldVal, newVal;   
    
    protected void selectElement(){
        int corner = randGen.nextInt(size);
        row = corner % rs;
        col = corner / rs;
        oldVal = A[row][col];
    }

    public void perform(){
        A[row][col] = newVal;
    }
    
    public void deselect(){
        double t = newVal;
        newVal = oldVal;
        oldVal = t;
    }
    
    public Iterator<LocalModificatorElement> iterator(){
        return new LocalModificatorIterator();
    }
    
    private class LocalModificatorIterator implements Iterator<LocalModificatorElement>{
        LocalModificatorElement e = null;
        
        public boolean hasNext() { return e == null; }
        
        public LocalModificatorElement next(){
            return e = new LocalModificatorElement(row, col, oldVal, newVal);
        }        
        
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }    
}    
