public abstract class LocalModificatorGreedyRotation extends LocalModificatorQuartet implements LocalModificatorGreedy{
    protected boolean iterable = true;
    
    protected int[][] P; //permutation matrix
    
    protected final int[][] rotRow = { {1,0}, {1,0} };
    protected final int[][] rotCol = { {0,0}, {1,1} }; 
    
    //this allows faster performance
    public void disableIterability() { iterable = false; }    
    
    public void init(double[][] A){
        super.init(A);
        P = new int[rs][cs];
    }

    public double[][] getRandomizedMatrix(){
        if(iterable)
            return A;
        else{
            double[][] randomizedMatrix = new double[rs][cs];
            for(int row = 0; row < rs; ++row)
                for(int col = 0; col < cs; ++col)
                    randomizedMatrix[row][col] = A[P[row][col]%rs][P[row][col]/rs];
            return randomizedMatrix;
        }
    }  
        
    protected boolean updateSelection(){
        if(iterable){
            for(int row = 0; row<2; row++)
                for(int col = 0; col<2; col++)
                    oldVals[row][col] = A[rows[row]][cols[col]];
            
            for(int row = 0; row<2; row++)
                for(int col = 0; col<2; col++)
                    newVals[row][col] = oldVals[rotRow[row][col]][rotCol[row][col]];
        }
            
        return cols[0] != cols[1] && rows[0] != rows[1];
    }
    
    public void perform(){
        if(iterable)
            super.perform();
        
        int tmp = P[rows[0]][cols[0]];
        P[rows[0]][cols[0]] = P[rows[1]][cols[0]];
        P[rows[1]][cols[0]] = P[rows[1]][cols[1]];
        P[rows[1]][cols[1]] = P[rows[0]][cols[1]];
        P[rows[0]][cols[1]] = tmp;
    }    
}
