public class ErrMeanStd extends MatrixErrorMeasure{    
    private double[] rowSum, colSum, rowSqSum, colSqSum;
    private double[] origRowSum, origColSum, origRowStd, origColStd;
    
    public void init(double[][] origMatrix, double[][] startMatrix, LocalModificator localMod){
        super.init(origMatrix, startMatrix, localMod);
        
        rowSum = new double[rs];
        rowSqSum = new double[rs];
        colSum = new double[cs];
        colSqSum = new double[cs];

        origRowSum = new double[rs];
        origRowStd = new double[rs];
        origColSum = new double[cs];
        origColStd = new double[cs];
    
        for(int row = 0; row < rs; ++row){
            for(int col = 0; col < cs; ++col){
                double add = startMatrix[row][col];
                rowSum[row] += add;
                colSum[col] += add;
                add = add*add;
                rowSqSum[row] += add;
                colSqSum[col] += add;
                
                add = origMatrix[row][col];
                origRowSum[row] += add;
                origColSum[col] += add;
                add = add*add;
                origRowStd[row] += add;
                origColStd[col] += add;
            }
        }        
        
        for(int row = 0; row < rs; ++row)
            origRowStd[row] = std(origRowStd[row],origRowSum[row], cs);
        
        for(int col = 0; col < cs; ++col)
            origColStd[col] = std(origColStd[col],origColSum[col], rs);        
    }
    
    //weighted std
    private double std(double sqSum, double sum, int n) { return Math.sqrt(n*sqSum-sum*sum); } 
    
    public double update(){
        double errDiff = 0;        
        
        for(LocalModificatorElement e : localMod){
            errDiff += changeSingleValue(e.row, rowSum, rowSqSum, e.oldVal, e.newVal, origRowSum, origRowStd, cs);
            errDiff += changeSingleValue(e.col, colSum, colSqSum, e.oldVal, e.newVal, origColSum, origColStd, rs);
        }
        
        return errDiff;
    }
           
    private double changeSingleValue(int elem, double[] sum, double[] sqSum, double oldVal, double newVal, double[] origSum, double[] origStd, int n){  
        double error = -calcError(sum[elem], sqSum[elem], origSum[elem], origStd[elem], n);
        sum[elem] += newVal-oldVal;
        sqSum[elem] += newVal*newVal - oldVal*oldVal;
        error += calcError(sum[elem], sqSum[elem], origSum[elem], origStd[elem], n);
        return error;      
    }
        
    private double calcError(double sum, double sqSum, double origSum, double origStd, int n){        
        return Math.abs(sum-origSum) + Math.abs(std(sqSum,sum,n)-origStd);
    }
}
