public class ErrCdfHist extends MatrixErrorMeasure{    
    private int bins;
    private int[][] rowCumSum;
    private int[][] colCumSum;
        
    private int getBin(double val) { return Math.min(bins-1,(int)(val*bins)); }
        
    public ErrCdfHist(int bins) { setParams(bins); }    
    public ErrCdfHist() { hasParams = false; }
    public void setParams(int bins) { this.bins = bins; hasParams = true; }
    public String getParams() { return "" + bins; }

    public void init(double[][] origMatrix, double[][] startMatrix, LocalModificator localMod){
        super.init(origMatrix, startMatrix, localMod);
        
        rowCumSum = new int[rs][bins];
        colCumSum = new int[cs][bins];
        
        for(int row = 0; row < rs; ++row){
            for(int col = 0; col < cs; ++col){
                int bin = getBin(origMatrix[row][col]);
                rowCumSum[row][bin]--;
                colCumSum[col][bin]--;                
                bin = getBin(startMatrix[row][col]);
                rowCumSum[row][bin]++;
                colCumSum[col][bin]++;
            }
        }
        
        for(int row = 0; row < rs; ++row)
            for(int i = 1; i<bins; ++i)
                rowCumSum[row][i] += rowCumSum[row][i-1];                    
        
        for(int col = 0; col < cs; ++col)
            for(int i = 1; i<bins; ++i)
                colCumSum[col][i] += colCumSum[col][i-1];
    }
    
    public double update(){
        double errDiff = 0;        
        
        for(LocalModificatorElement e : localMod){
            errDiff += changeSingleValue(rowCumSum[e.row], e.oldVal, e.newVal);
            errDiff += changeSingleValue(colCumSum[e.col], e.oldVal, e.newVal);
        }
        
        return errDiff/bins;
    }
           
    private int changeSingleValue(int[] cumSum, double oldVal, double newVal){      
        int error = 0;
        if(newVal>oldVal){
            int j = getBin(newVal);
            for(int i = getBin(oldVal); i<j; i++){
                error -= Math.abs(cumSum[i]);
                cumSum[i]--;
                error += Math.abs(cumSum[i]);
            }
        } else{
            int j = getBin(oldVal);
            for(int i = getBin(newVal); i<j; i++){
                error -= Math.abs(cumSum[i]);
                cumSum[i]++;
                error += Math.abs(cumSum[i]);
            }
        }
        return error;
    }
}
