%Default parameters for different combinations of matrix error measure
%and local modificator are defined here. The default parameters can be
%defined for different dataset names. 
%
%The parameters has to be defined for each matError-localMod combination.
%However, if an exact matError or localMod match is not found, the closest
%prefix is used. 
%
%The possible matErrors are 'ErrCdf', 'ErrCdfHist', 'ErrMeanStd', 'ErrNull'
%
%ErrNull corresponds to Greedy
%
%And the possible localMods are 'ModAdd', 'ModChange', 'ModMask',
%'ModResample, 'ModRotate', 'ModSwap'
%
%The parameters that has to be defined are:
%
%Attempts: the number of attempts
%ErrConst: the error constant for Metropolis algorithm, 
%MatrixErrorMeasure: parameter values for each matrix error measure
%LocalMod: default local modification with each error measure
%LocalModParams: parameter values for each local modification

function [A,E,L,M,P] = getParametersDefault(X)

%attempts
A = {
    '',   'Err',           'Mod',         100;
    };


%errConst - THESE SHOULD ESPECIALLY BE TUNED DATAWISE
E = {
    '',   'ErrCdf',        'Mod',         40; 
    '',   'ErrMeanStd',    'Mod',         15;
    '',   'ErrMeanStd',    'ModMask',     30;    
    '',   'ErrNull',       'Mod',         0;
    };


%parameters for matrix error measures
M = {
    '',   'Err',           'Mod',         {};
    '',   'ErrCdfHist',    'Mod',         {100};
    };


%default local modification
L = {
    '',   'Err',           'ModRotate';
    '',   'ErrMean',       'ModMask';
    '',   'ErrNull',       'ModSwap';
    };


%parameters for local modifications
P = {
    '',   'Err'            'Mod'          {};
    '',   'Err',           'ModAdd',      {0.1};
    '',   'Err',           'ModMask',     {0.1};
    '',   'Err',           'ModSwap',     {10,10};
    '',   'ErrNull',       'Mod',         {};
    '',   'ErrNull',       'ModSwap',     {floor(2*sqrt(size(X,2))),floor(2*sqrt(size(X,1)))};    
    };
