/*
 * Decompiled with CFR 0.152.
 */
public class ErrMeanStd
extends MatrixErrorMeasure {
    private double[] rowSum;
    private double[] colSum;
    private double[] rowSqSum;
    private double[] colSqSum;
    private double[] origRowSum;
    private double[] origColSum;
    private double[] origRowStd;
    private double[] origColStd;

    @Override
    public void init(double[][] dArray, double[][] dArray2, LocalModificator localModificator) {
        int n;
        super.init(dArray, dArray2, localModificator);
        this.rowSum = new double[this.rs];
        this.rowSqSum = new double[this.rs];
        this.colSum = new double[this.cs];
        this.colSqSum = new double[this.cs];
        this.origRowSum = new double[this.rs];
        this.origRowStd = new double[this.rs];
        this.origColSum = new double[this.cs];
        this.origColStd = new double[this.cs];
        for (n = 0; n < this.rs; ++n) {
            int n2 = 0;
            while (n2 < this.cs) {
                double d = dArray2[n][n2];
                int n3 = n;
                this.rowSum[n3] = this.rowSum[n3] + d;
                int n4 = n2;
                this.colSum[n4] = this.colSum[n4] + d;
                d *= d;
                int n5 = n;
                this.rowSqSum[n5] = this.rowSqSum[n5] + d;
                int n6 = n2;
                this.colSqSum[n6] = this.colSqSum[n6] + d;
                d = dArray[n][n2];
                int n7 = n;
                this.origRowSum[n7] = this.origRowSum[n7] + d;
                int n8 = n2;
                this.origColSum[n8] = this.origColSum[n8] + d;
                d *= d;
                int n9 = n;
                this.origRowStd[n9] = this.origRowStd[n9] + d;
                int n10 = n2++;
                this.origColStd[n10] = this.origColStd[n10] + d;
            }
        }
        for (n = 0; n < this.rs; ++n) {
            this.origRowStd[n] = this.std(this.origRowStd[n], this.origRowSum[n], this.cs);
        }
        for (n = 0; n < this.cs; ++n) {
            this.origColStd[n] = this.std(this.origColStd[n], this.origColSum[n], this.rs);
        }
    }

    private double std(double d, double d2, int n) {
        return Math.sqrt((double)n * d - d2 * d2);
    }

    @Override
    public double update() {
        double d = 0.0;
        for (LocalModificatorElement localModificatorElement : this.localMod) {
            d += this.changeSingleValue(localModificatorElement.row, this.rowSum, this.rowSqSum, localModificatorElement.oldVal, localModificatorElement.newVal, this.origRowSum, this.origRowStd, this.cs);
            d += this.changeSingleValue(localModificatorElement.col, this.colSum, this.colSqSum, localModificatorElement.oldVal, localModificatorElement.newVal, this.origColSum, this.origColStd, this.rs);
        }
        return d;
    }

    private double changeSingleValue(int n, double[] dArray, double[] dArray2, double d, double d2, double[] dArray3, double[] dArray4, int n2) {
        double d3 = -this.calcError(dArray[n], dArray2[n], dArray3[n], dArray4[n], n2);
        int n3 = n;
        dArray[n3] = dArray[n3] + (d2 - d);
        int n4 = n;
        dArray2[n4] = dArray2[n4] + (d2 * d2 - d * d);
        return d3 += this.calcError(dArray[n], dArray2[n], dArray3[n], dArray4[n], n2);
    }

    private double calcError(double d, double d2, double d3, double d4, int n) {
        return Math.abs(d - d3) + Math.abs(this.std(d2, d, n) - d4);
    }
}

