/*
 * Decompiled with CFR 0.152.
 */
public class ErrCdfHist
extends MatrixErrorMeasure {
    private int bins;
    private int[][] rowCumSum;
    private int[][] colCumSum;

    private int getBin(double d) {
        return Math.min(this.bins - 1, (int)(d * (double)this.bins));
    }

    public ErrCdfHist(int n) {
        this.setParams(n);
    }

    public ErrCdfHist() {
        this.hasParams = false;
    }

    public void setParams(int n) {
        this.bins = n;
        this.hasParams = true;
    }

    @Override
    public String getParams() {
        return "" + this.bins;
    }

    @Override
    public void init(double[][] dArray, double[][] dArray2, LocalModificator localModificator) {
        int n;
        int n2;
        super.init(dArray, dArray2, localModificator);
        this.rowCumSum = new int[this.rs][this.bins];
        this.colCumSum = new int[this.cs][this.bins];
        for (n2 = 0; n2 < this.rs; ++n2) {
            for (n = 0; n < this.cs; ++n) {
                int n3 = this.getBin(dArray[n2][n]);
                int[] nArray = this.rowCumSum[n2];
                int n4 = n3;
                nArray[n4] = nArray[n4] - 1;
                int[] nArray2 = this.colCumSum[n];
                int n5 = n3;
                nArray2[n5] = nArray2[n5] - 1;
                n3 = this.getBin(dArray2[n2][n]);
                int[] nArray3 = this.rowCumSum[n2];
                int n6 = n3;
                nArray3[n6] = nArray3[n6] + 1;
                int[] nArray4 = this.colCumSum[n];
                int n7 = n3;
                nArray4[n7] = nArray4[n7] + 1;
            }
        }
        for (n2 = 0; n2 < this.rs; ++n2) {
            for (n = 1; n < this.bins; ++n) {
                int[] nArray = this.rowCumSum[n2];
                int n8 = n;
                nArray[n8] = nArray[n8] + this.rowCumSum[n2][n - 1];
            }
        }
        for (n2 = 0; n2 < this.cs; ++n2) {
            for (n = 1; n < this.bins; ++n) {
                int[] nArray = this.colCumSum[n2];
                int n9 = n;
                nArray[n9] = nArray[n9] + this.colCumSum[n2][n - 1];
            }
        }
    }

    @Override
    public double update() {
        double d = 0.0;
        for (LocalModificatorElement localModificatorElement : this.localMod) {
            d += (double)this.changeSingleValue(this.rowCumSum[localModificatorElement.row], localModificatorElement.oldVal, localModificatorElement.newVal);
            d += (double)this.changeSingleValue(this.colCumSum[localModificatorElement.col], localModificatorElement.oldVal, localModificatorElement.newVal);
        }
        return d / (double)this.bins;
    }

    private int changeSingleValue(int[] nArray, double d, double d2) {
        int n = 0;
        if (d2 > d) {
            int n2 = this.getBin(d2);
            for (int i = this.getBin(d); i < n2; ++i) {
                n -= Math.abs(nArray[i]);
                int n3 = i;
                nArray[n3] = nArray[n3] - 1;
                n += Math.abs(nArray[i]);
            }
        } else {
            int n4 = this.getBin(d);
            for (int i = this.getBin(d2); i < n4; ++i) {
                n -= Math.abs(nArray[i]);
                int n5 = i;
                nArray[n5] = nArray[n5] + 1;
                n += Math.abs(nArray[i]);
            }
        }
        return n;
    }
}

