/*
 * Decompiled with CFR 0.152.
 */
public class Metropolis
implements MatrixError {
    private MersenneTwisterFast randGen;
    private double errConst;
    private boolean hasErrConst = false;
    private MatrixErrorMeasure matError;
    private LocalModificator localMod;

    public Metropolis(double d, MatrixErrorMeasure matrixErrorMeasure) {
        this.setErrConst(d);
        this.matError = matrixErrorMeasure;
    }

    public Metropolis(MatrixErrorMeasure matrixErrorMeasure, double d) {
        this(d, matrixErrorMeasure);
    }

    public Metropolis(double d) {
        this.setErrConst(d);
        this.setDefaultMatError();
    }

    public Metropolis(MatrixErrorMeasure matrixErrorMeasure) {
        this.matError = matrixErrorMeasure;
    }

    public Metropolis() {
        this.setDefaultMatError();
    }

    @Override
    public void init(double[][] dArray, double[][] dArray2, LocalModificator localModificator, MersenneTwisterFast mersenneTwisterFast) {
        if (!this.hasErrConst) {
            throw new RuntimeException("Error: ErrConst has not been initialized.");
        }
        this.randGen = mersenneTwisterFast;
        this.matError.init(dArray2, dArray, localModificator);
        this.localMod = localModificator;
    }

    @Override
    public boolean acceptModification() {
        if (Math.log(this.randGen.nextDouble()) < -this.errConst * this.matError.update()) {
            return true;
        }
        this.localMod.deselect();
        this.matError.update();
        return false;
    }

    @Override
    public String getParams() {
        return "" + this.errConst;
    }

    public void setErrConst(double d) {
        this.errConst = d;
        this.hasErrConst = true;
    }

    public boolean hasErrConst() {
        return this.hasErrConst;
    }

    public double getErrConst() {
        return this.errConst;
    }

    @Override
    public MatrixErrorMeasure getMatrixErrorMeasure() {
        return this.matError;
    }

    private void setDefaultMatError() {
        this.matError = new ErrCdfHist();
    }
}

