/*
 * Decompiled with CFR 0.152.
 */
import java.util.Iterator;

public abstract class LocalModificatorQuartet
extends LocalModificator {
    protected int[] rows = new int[2];
    protected int[] cols = new int[2];
    protected double[][] oldVals = new double[2][2];
    protected double[][] newVals = new double[2][2];

    protected void selectElements() {
        int n = this.randGen.nextInt(this.size);
        this.cols[0] = n / this.rs;
        this.rows[0] = n % this.rs;
        do {
            n = this.randGen.nextInt(this.size);
            this.cols[1] = n / this.rs;
            this.rows[1] = n % this.rs;
        } while (this.cols[0] == this.cols[1] || this.rows[0] == this.rows[1]);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.oldVals[i][j] = this.A[this.rows[i]][this.cols[j]];
            }
        }
    }

    @Override
    public void perform() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.A[this.rows[i]][this.cols[j]] = this.newVals[i][j];
            }
        }
    }

    @Override
    public void deselect() {
        double[][] dArray = this.newVals;
        this.newVals = this.oldVals;
        this.oldVals = dArray;
    }

    @Override
    public Iterator<LocalModificatorElement> iterator() {
        return new LocalModificatorIterator();
    }

    private class LocalModificatorIterator
    implements Iterator<LocalModificatorElement> {
        int r = 0;
        int c = -1;

        private LocalModificatorIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.r < 1 || this.c < 1;
        }

        @Override
        public LocalModificatorElement next() {
            ++this.c;
            if (this.c == 2) {
                this.c = 0;
                ++this.r;
            }
            return new LocalModificatorElement(LocalModificatorQuartet.this.rows[this.r], LocalModificatorQuartet.this.cols[this.c], LocalModificatorQuartet.this.oldVals[this.r][this.c], LocalModificatorQuartet.this.newVals[this.r][this.c]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

