/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;

public class ErrCdf
extends MatrixErrorMeasure {
    private double[][] colVals;
    private double[][] rowVals;
    private double[][] origColVals;
    private double[][] origRowVals;

    @Override
    public void init(double[][] dArray, double[][] dArray2, LocalModificator localModificator) {
        super.init(dArray, dArray2, localModificator);
        this.rowVals = new double[this.rs][this.cs];
        this.colVals = new double[this.cs][this.rs];
        this.origRowVals = new double[this.rs][this.cs];
        this.origColVals = new double[this.cs][this.rs];
        this.initVals(dArray2, this.rowVals, this.colVals);
        this.initVals(dArray, this.origRowVals, this.origColVals);
    }

    private void initVals(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        for (int i = 0; i < this.rs; ++i) {
            for (int j = 0; j < this.cs; ++j) {
                double d = dArray[i][j];
                dArray2[i][j] = d;
                dArray3[j][i] = d;
            }
        }
        for (double[] dArray4 : dArray2) {
            Arrays.sort(dArray4);
        }
        for (double[] dArray4 : dArray3) {
            Arrays.sort(dArray4);
        }
    }

    @Override
    public double update() {
        double d = 0.0;
        for (LocalModificatorElement localModificatorElement : this.localMod) {
            d += this.changeSingleValue(this.rowVals[localModificatorElement.row], this.origRowVals[localModificatorElement.row], localModificatorElement.oldVal, localModificatorElement.newVal);
            d += this.changeSingleValue(this.colVals[localModificatorElement.col], this.origColVals[localModificatorElement.col], localModificatorElement.oldVal, localModificatorElement.newVal);
        }
        return d;
    }

    private double changeSingleValue(double[] dArray, double[] dArray2, double d, double d2) {
        int n;
        double d3 = 0.0;
        if (d2 > d) {
            while (n + 1 < dArray.length && dArray[n + 1] < d2) {
                d3 += Math.abs(dArray2[n] - dArray[n + 1]) - Math.abs(dArray2[n] - dArray[n]);
                dArray[n] = dArray[n + 1];
                ++n;
            }
        } else {
            for (n = Arrays.binarySearch(dArray, d); n > 0 && dArray[n - 1] > d2; --n) {
                d3 += Math.abs(dArray2[n] - dArray[n - 1]) - Math.abs(dArray2[n] - dArray[n]);
                dArray[n] = dArray[n - 1];
            }
        }
        dArray[n] = d2;
        return d3 += Math.abs(dArray2[n] - d2) - Math.abs(dArray2[n] - dArray[n]);
    }
}

