function [ G ] = naturalNeighborLP( X, tol )
%NATURALNEIGHBORSLP A linear programming approach to calculating the
%natural neighbors, i.e. the voronoi adjecancy problem. The LP solution is
%applicable to data sets with a high dimensionality.
% Mika Juuti, 2014-09-22

if nargin < 2
    tol=1e-6;
end
n = size(X,1);

Q = []; %Query points
Ix = [];
X0 = [];
parfor i=1:n
    a = X(i,:);
    for j=(i+1):n % stops before n
        Q = [Q; (a+X(j,:))/2];
        Ix = [Ix; [i j]];
        X0i = zeros(n,1);
        X0i(i) = 0.5; X0i(j) = 0.5; 
        X0 = [X0 X0i];
    end
end

m = size(Q,1);
%%
G = zeros(n);
w = sum(X.^2,2)';
Aeq = [X'; ones(1,n)];

N = [];
opts.Algorithm = 'simplex';

for i=1:m % use parfor i=1:m with parallell computing toolbox
    beq = [Q(i,:)'; 1];
    lb = zeros(n,1);
    ub = ones(n,1);
    X0i = X0(:,i);

    u = linprog(w,[],[],Aeq,beq,lb,ub,X0i,opts);
    if (sum(ismember(Ix(i,:),find(u>tol))) == 2) %if u contains the two test points Ix(i,:)
        loc = Ix(i,:);
        N = [N; loc];
        % disp(['LP ' num2str(i) ' of ' num2str(m) ' completed.'])
    else
    end
    shg
end

pairs = size(N,1);
for i=1:pairs
    loc = N(i,:);
    G(loc(1),loc(2)) = 1;
    G(loc(2),loc(1)) = 1;
end


end

