function [mappedX, mapping, K] = kernel_pca(x, options)

[n, d] = size(x);

if nargin < 2
%    options.r = d;
   options.kernelType = 'linear';
%    options.t = silverman(x); 
%    options.m = d; 
end

% setting default values for options
if(~isfield(options,'r')); options.r = d; end 
if(~isfield(options,'kernelType')); options.r = 'linear'; end 
if(~isfield(options,'t')); options.t = silverman(x); end
if(~isfield(options,'m')); options.m = d; end 

% in the format K = constructKernel(F(:,1:5)',F(:,1:6)',options);
K = constructKernel(x,x,options);
H = eye(n) - 1/n*ones(n);
% the k's are already in the kernel matrix K. Otherwise, they would be
% calculated as constructKernel(f',F',options), where f is the new point
[A,L] = eig(H*K*H); % eigenvectors (A) and eigenvalues (L) in the dual space

% The original points can be mapped back to the original space as mappedX = K * mapping;
mapping = A(:,1:options.m)/sqrt(L(1:options.m,1:options.m));
% The mapping is not centered around 0. The mapped points can be recentered with
% xCentered = H * mappedX;
mappedX = K*mapping;