function P = SDPP_sqlp(X, Y, W0, G, bC, bK, maxit,bS)
% Supervise Distance Preserving Projection (SDPP)
% If the kernel version on SDPP is used, X is the kernel matrix Kx;  
% otherwise X is the set of samples. 
% bC (boolean Classification) has the value 0 if the task is a a regression
% task and 1 in the case of a classification task. Default value is 0.
% bK: X and Y are kernels (1), X and Y are samples (0)
% r: the reduced dimensionality
% Mika Juuti et. al. 2014-09-22

[n d] = size(X);
addpath(pathdef);

%% Form matrices
[A, b] = formConstraints(X,Y,G,bC,bK,bS);

%% Form matrix
% symmetrize b
if ~bK
    b = reshape(b,[d,d]);
else
    b = reshape(b,[n,n]);
end
b = (b+b')/2;
b = b(:);


%% %%%%%%%%%%%%%%%%%%%%%%%%% SQLP %%%%%%%%%%%%%%%%%%%%%%%%%%

[blk,At,C1,b1] = clcPr(A, b);  % formulate the SQLP

opts = [];
if nargin >= 8
    opts.maxit = maxit;
end
[obj1,P1,y1,Z1,info1] = sqlp(blk,At,C1,b1,opts); % solve the SQLP

P = full(P1{1});
