function [Mindex,distsum,label,dist] = kmedoidspp(X, k, plusplus)
%K-medoids (Partitioning Around Medoids) with optional initialization
%similar to k-means++

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

%% Init
n = size(X,1);
Mindex = zeros(k,1);

% Precompute distance matrix
distancesFull = computeDist(X,1:n);

%% Init medoids
if plusplus
    Mindex(1) = ceil(rand*n); % Select first medoid uniformly at random

    for i = 2:k
        prob = cumsum(min(distancesFull(:, Mindex(1:i-1)),[],2));
        if(prob(end) > 0)
            Mindex(i) = find(prob > rand*prob(end),1,'first');
        else
            notselected = setdiff(1:n,Mindex);
            Mindex(i) = notselected(randi(length(notselected)));
        end
    end
else
    rp = randperm(n);
    Mindex = rp(1:k)';
end

%% Repeat optimization until no change
% Compute distances to current medoids
distances = distancesFull(:, Mindex);
[dist,label] = min(distances,[],2);
distsum = sum(dist);

change = true;

while(change)
    % Store previous solution
    Mindexprev = Mindex;
        
    % Try to swap any medoid with any point
    for i = 1:k
        for j = 1:n
            distances_new = distances;
            distances_new(:,i) = distancesFull(:,j);
            [distnew, labelnew] = min(distances_new,[],2);
            distnewsum = sum(distnew);
            if(distnewsum < distsum)
                Mindex(i) = j;
                distances = distances_new;
                dist = distnew;
                label = labelnew;
                distsum = distnewsum;
            end
        end
    end
    
    % Check if solution has changed
    if(all(Mindex == Mindexprev))
        change = false;
    end
end

end

function distances = computeDist(X, Mindex)
% Compute distance for all points in X to medoids with given indices

distances = zeros(size(X,1), length(Mindex));

for i = 1:length(Mindex)
    distances(:,i) = sum(bsxfun(@minus,X,X(Mindex(i),:)).^2,2);
end

end