% Script for analyzing type/token ratio distributions at different
% granularities in several of Dickens' books and Pride & Prejudice

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

%% Clear workspace
clear;

%% Read data
load BNCindex.mat;
load classCode.mat;

class = extractClass(classCode);

clear classCode;

%% Take only texts with length 2000 or more
keep = true(length(Index),1);

for i = 1:length(Index)
    if(length(Index{i}) < 2000)
        keep(i) = false;
    end
end

Index = Index(keep);
class = class(keep);

clear keep i;

%% Select 100 texts per class
nperclass = 100;
textlist = zeros(nperclass*4,1);

% for i = 1:4
%     class_i = find(class == i);
%     sample = randperm(length(class_i),nperclass);
%     textlist((1:nperclass)+(i-1)*nperclass) = class_i(sample);
% end

load dami_booksHLR.mat textlist;

clear nperclass i class_i sample;

%% Compute hapax legomenon ratio-window matrix and clustering
% Init
windowsizes = 1:1000;
ncols = 500;

k = 3;
nreps = 500;
samplesize = 60;
plusplus = true;

exprep = 1;

ntexts = length(textlist);
err = zeros(ntexts,exprep);
ws = cell(ntexts,exprep);
err_rand = zeros(ntexts,exprep);
ws_rand = cell(ntexts,exprep);

tic_total = tic;

parfor i = 1:ntexts
    index = Index{textlist(i)}; %#ok<PFBNS>
    
    for j = 1:exprep
        tic_i = tic;
        HLR = computeHapaxRatioMatrixSample(index, ...
            windowsizes, ncols);
        fprintf('%s\n',['Hapax legomenon ratio matrix ' num2str(i) ...
            ' computed in ' num2str(toc(tic_i)) ' seconds.']);
        
        tic_i = tic;
        [ws{i,j},err(i,j)] = clara(HLR,k,nreps,samplesize,plusplus);
        fprintf('%s\n',['Clustering ' num2str(i) ' computed in ' ...
            num2str(toc(tic_i)) ' seconds.']);
    end
end

fprintf('%s\n',['Experiment finished in ' num2str(toc(tic_total)) ...
    ' seconds.']);

clear ntexts i j tic_total index tic_i HLR HLR_rand;

%% Save error
save dami_booksHLR.mat textlist windowsizes ncols k nreps samplesize ...
    plusplus err ws;