function classlabel = extractClass(classCode)
% Extract classes conversation, fiction, newspaper and academic from list.

% Copyright (c) 2015, Jefrey Lijffijt
%
% Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OU
T OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

classlabel = zeros(length(classCode),1);
for i = 1:length(classCode)
    cc = classCode{i};
    if(strfind(cc,'W fict prose'))
        classlabel(i) = 2;
    elseif(strfind(cc,'W newsp brdsht'))
        classlabel(i) = 3;
    elseif(strfind(cc,'W ac'))
        classlabel(i) = 4;
    elseif(strfind(cc,'S conv'))
        classlabel(i) = 1;
    end
end

end