#!/usr/bin/python

from expressions import *
from byices import Yices
import preproc

D1N = "delta-1"
D2N = "delta-2"


@preproc.RewriteExpr(True, False, False)
def _conv_repl(surrounding, expr, prefix, is_def, variables, deltavar):
	assert not prefix
	assert not is_def
	assert isinstance(expr, AstExpression)
	assert len(expr) == 1
	assert isinstance(expr[0], basestring)
	assert expr[0] in variables
	if variables[expr[0]] == REAL:
		return AstExpression('+', expr, deltavar)

def is_convex(variables, constants, definitions, expr, yices_file=None):
	assert isinstance(expr, Expression)
	assert isinstance(variables, dict)
	assert all(isinstance(x, basestring) for x in variables)
	assert all(isinstance(x, Type) for x in variables.itervalues())
	assert isinstance(definitions, list)
	assert all(isinstance(x[0], basestring) for x in definitions)
	assert all(isinstance(x[1], Expression) for x in definitions)
	assert isinstance(expr, Expression)
	assert yices_file == None or isinstance(yices_file, basestring)
	
	defset = set(x[0] for x in definitions)
	
	# Preprocess
	xa =                    expr
	xb = AstExpression("!", _conv_repl(variables, defset, constants, expr, '', variables, AstExpression(D1N)))
	xc =                    _conv_repl(variables, defset, constants, expr, '', variables, AstExpression(D2N))
	
	# Set up yices
	yi = Yices(yices_file)
	for (i, c) in enumerate(constants):
		r = yi.add_constant(c)
		assert r == i
	clocks = []
	for n, t in variables.iteritems():
		yi.add_var(n, t)
		if t == REAL:
			clocks.append(n)
	for n, e in definitions:
		yi.add_def(n, yi.encode(e))
	yi.add_var(D1N, REAL)
	yi.add_var(D2N, REAL)
	
	for clk in clocks:
		expr = AstExpression(">=", clk, Number(0))
		yi.assertion(yi.encode(expr))
	
	yi.assertion(yi.encode(AstExpression(">", D1N, Number(0))))
	yi.assertion(yi.encode(AstExpression(">", D2N, D1N)))
	yi.assertion(yi.encode(xa))
	yi.assertion(yi.encode(xb))
	yi.assertion(yi.encode(xc))
	
	ret = not yi.check()
	
	return (ret, None if ret else yi.get_model())

if __name__ == "__main__":
	### DOES NOT WORK ANYMORE ###
	a = Variable("a", REAL)
	b = Variable("b", BOOLEAN)
	c = Variable("c", BOOLEAN)
	expr = AstExpression("&", b, ("|", (">", a, "4"), ("<", a, "5")))
	print expr, is_convex(expr, [a], "tmp/y1.txt")
		
	expr = AstExpression("&", b, ("|", (">", a, "4"), ("<", a, "2")))
	print expr, is_convex(expr, [a], "tmp/y2.txt")
	
	expr = AstExpression("<->", b, c)
	print expr, is_convex(expr, [], "tmp/y3.txt")

