from expressions import *
import nusmv_modules
import preproc
from names import DELTAVAR_NAME, OPEN, INT_SUFFIX, FRAC_SUFFIX, DELTA_INT, DELTA_FRAC
from preproc import PRIME_SUFFIX
import names
import copy
import brind

OBLIGATION = '+%d-obligation'
RESET = '+%d-reset'
CLOCK = '+%d-clk'
RIGHTHAT = '+%d-righthat'
TIMING = '+%d-timing'
LEFT_OPEN = '+%d-left-open'
RIGHT_OPEN = '+%d-right-open'
SUBEXPRESSION = '+%d-subexp'

class LtlException(Exception):
	pass

DUALS = [
	("F", "G"),
	("U", "V"),
	("|", "&"),
	("X", "X"),
	('SR', 'SU'),
	('ULT', 'RLT'),
	('ULE', 'RLE'),
	('UGT', 'RGT'),
	('UGE', 'RGE'),
	('FLT', 'GLT'),
	('FLE', 'GLE'),
	('FLZ', 'GLZ')
]

NEG_ABS_OPS = [ 
	('=', '!='),
	('<', '>='),
	('<=', '>')
]

DUAL = {}
for (a, b) in DUALS:
	DUAL[a] = b
	DUAL[b] = a

NEG_ABS = {}
for a, b in NEG_ABS_OPS:
	NEG_ABS[a] = b
	NEG_ABS[b] = a

NEG_PASSTHROUGH = []
E = AstExpression

LTL_OPS = set(['F', 'G', 'X', 'U', 'V'])
UNTIMED_OPS = set(['SR', 'SU', 'FLZ', 'GLZ'])
UB_OPS = set(['FLT', 'FLE',  'GLT', 'GLE'])
REDUCIBLE_OPS = set(['ULT', 'ULE',  'RLT', 'RLE'])
LB_OPS = set(['UGT', 'UGE', 'RGT', 'RGE'])
TIMED_OPS = LTL_OPS.union(LB_OPS).union(UB_OPS).union(REDUCIBLE_OPS)
OPS = TIMED_OPS.union(UNTIMED_OPS)

def bmc_encode(prop, indices, bound, subexp = None, already_pos_normal=False):
	if isinstance(prop, nusmv_modules.Specification):
		assert prop.type == "LTLSPEC"
		prop = prop.expression
	assert isinstance(prop, Expression)
	assert isinstance(bound, (int, long))
	assert isinstance(indices, list)
	assert all(x <= bound for x in indices)
	assert subexp == None or isinstance(subexp, list)
	
	#Positive normal form
	if not already_pos_normal:
		prop = positive_normal_form(prop)
		print 'Positive normal form:', prop
	
	#Search subexpressions
	if subexp == None:
		specvar = Variable("spec", BOOLEAN)
		
		def subexp_cb(expr, _, (out, nextindex)):
			if isinstance(expr, AstExpression) and expr[0] in REDUCED_LTLOPS:
				if not expr in out:
					out[expr] = Variable("subexp_%d" % nextindex[0], BOOLEAN)
					nextindex[0] = nextindex[0] + 1
		dct = {prop:specvar}
		prop.traverse_and_replace(subexp_cb, (dct, [0]))
		
		#Replace LTL-subexpressions
		def subexp_repl_cb(expr, _, (dct, toplevel)):
			if (not toplevel[0]) and expr in dct:
				return dct[expr]
			toplevel[0] = False
		
		subexp = []
		for (ex, nm) in dct.iteritems():
			subexp.append((nm, ex.traverse_and_replace(subexp_repl_cb, (dct, [True]))))
		
	#Encode
	loopvar = Variable("loop", BOOLEAN) #TODO
	
	comments = []
	last_state_assertions = []
	interm_state_assertions = []
	all_state_assertions = []
	
	for (name, exp) in subexp:
		comments.append("%s: %s" % (name, exp))
		assert isinstance(name, Variable)
		nameb = Variable(name.name + "_b", name.type)
		
		if isinstance(exp, AstExpression) and exp[0] in REDUCED_LTLOPS:
			if exp[0] == "U":
				assert len(exp) == 3
				interm_state_assertions.append(AstExpression("<->",
							name,
							("|", exp[2], ("&", exp[1], ("next", name)))))
				interm_state_assertions.append(AstExpression("<->",
							nameb,
							("|", exp[2], ("&", exp[1], ("next", nameb)))))
				last_state_assertions.append(None)
				last_state_assertions.append(None)
			elif exp[0] == "V":
				assert len(exp) == 3
				interm_state_assertions.append(AstExpression("<->",
							name,
							("&", exp[2], ("|", exp[1], ("next", name)))))
				interm_state_assertions.append(AstExpression("<->",
							nameb,
							("&", exp[2], ("|", exp[1], ("next", nameb)))))
				last_state_assertions.append(None)
				last_state_assertions.append(None)
			elif exp[0] == "X":
				assert len(exp) == 2
				interm_state_assertions.append(AstExpression("<->", name, ("next", exp[1])))
				last_state_assertions.append(None)
				#TODO closing expr
			else:
				assert False, exp
		else:
			#No LTL inside
			exp = AstExpression("<->", name, exp)
			all_state_assertions.append(exp)
		
		
	return comments, all_state_assertions, interm_state_assertions, last_state_assertions

def positive_normal_form(e, variables, constants, definitions):
	assert isinstance(definitions, list)
	assert all(isinstance(x, tuple) for x in definitions)
	assert all(len(x) == 2 for x in definitions)
	definitions = set(x[0] for x in definitions)
	return _pos_normal_form(e, False, variables, constants, definitions)\
				.traverse_and_replace(_gf_repl_callback, None)

def _gf_repl_callback(expr, _, __):
	if isinstance(expr, AstExpression) and len(expr) == 2 and expr[0] in ['G', 'F'] \
				and isinstance(expr[1], AstExpression) and len(expr[1]) == 2         \
				and expr[1][0] in ['G', 'F']:
		if expr[0] == expr[1][0]:
			return AstExpression(expr[0],
					expr[1][1]).traverse_and_replace(_gf_repl_callback, None)
		else:
			return AstExpression(expr[0] + expr[1][0], expr[1][1]\
					.traverse_and_replace(_gf_repl_callback, None))

def _simplify_ub_cb(expr, _, __):
	if isinstance(expr, AstExpression) and expr[0] in ['ULT', 'ULE', 'RLT', 'RLE']:
		op = expr[0]
		to = ('F' if op[0] == 'U' else 'G') + op[1:]
		uto = 'S' + op[0]
		comb = '&' if op[0] == 'U' else '|'
		lhs = expr[2].traverse_and_replace(_simplify_ub_cb, None)
		rhs = expr[3].traverse_and_replace(_simplify_ub_cb, None)
		return AstExpression(comb, (uto, lhs, rhs), (to, expr[1], rhs))
	else:
		return None

def _simplify_zero_cb(expr, _, __):
	if isinstance(expr, AstExpression):
		if expr[0] == 'FLT' and expr[1].value == 0:
			return BooleanConstant(False)
		elif expr[0] == 'GLT' and expr[1].value == 0:
			return BooleanConstant(True)
		elif expr[0] in ['GLE', 'FLE'] and expr[1].value == 0:
			rhs = expr[2].traverse_and_replace(_simplify_zero_cb, None)
			return AstExpression(expr[0][:-1] + 'Z', rhs)
		elif expr[0] in ['UGE', 'RGE'] and expr[1].value == 0:
			lhs = expr[2].traverse_and_replace(_simplify_zero_cb, None)
			rhs = expr[3].traverse_and_replace(_simplify_zero_cb, None)
			return AstExpression('S' + expr[0][0], lhs, rhs)

def simplify(expr):
	return expr.traverse_and_replace(_simplify_ub_cb,
				None).traverse_and_replace(_simplify_zero_cb, None)

def _pos_normal_form(e, negated, variables, constants, definitions):
	assert isinstance(e, Expression), (e, type(e))
	
	if isinstance(e, CaseExpression): 
		newcases = []
		for c in e.cases:
			newcases.append((c[0], _pos_normal_form(c[1], negated, constants, definitions)))
		r = CaseExpression(newcases)
	elif isinstance(e, BooleanConstant) and negated:
		r = BooleanConstant(not e.value)
	elif isinstance(e, Constant):
		assert not negated
		r = e
	else:
		assert isinstance(e, AstExpression)
		if e[0] == '!':
			assert len(e) == 2
			r = _pos_normal_form(e[1], not negated, variables, constants, definitions)
		elif len(e) == 1:
			if e[0] in constants:
				assert not negated
				r = e
			elif e[0] in definitions:
				if negated:
					r = AstExpression('!', e)
				else:
					r = e
			else:
				assert e[0] in variables, (e, variables)
				if variables[e[0]] == BOOLEAN and negated:
					r = AstExpression('!', e)
				else:
					assert not negated
					r = e
		elif negated:
			if e[0] == '->':
				assert len(e) == 3
				r = AstExpression('&',
						_pos_normal_form(e[1], False, variables, constants, definitions),
						_pos_normal_form(e[2], True, variables, constants, definitions))
			elif e[0] == '<->':
				assert len(e) == 3
				r = AstExpression('<->',
						_pos_normal_form(e[1], False, variables, constants, definitions),
						_pos_normal_form(e[2], True, variables, constants, definitions)
					)
			elif e[0] in NEG_ABS:
				r = AstExpression([NEG_ABS[e[0]]] + [_pos_normal_form(x, False, variables,\
							constants, definitions) for x in e[1:]])
			elif e[0] in DUAL:
				if e[0] in TIMED_OPS:
					r = AstExpression([DUAL[e[0]], e[1]] + \
							[_pos_normal_form(x, True, variables, constants, definitions)\
										for x in e[2:]])
				else:
					r = AstExpression([DUAL[e[0]]] + \
							[_pos_normal_form(x, True, variables, constants, definitions)\
										for x in e[1:]])
			else:
				assert e[0] in NEG_PASSTHROUGH
				r = AstExpression([e[0]] + [_pos_normal_form(x, False, variables,\
							constants, definitions) for x in e[1:]])
		else:
			if e[0] in TIMED_OPS:
#				r = AstExpression([e[0], e[1]] + [_pos_normal_form(x, False, variables,\
#							constants, definitions) for x in e[3:]])
				r = AstExpression([e[0], e[1]] + \
						[_pos_normal_form(x, False, variables, constants, definitions)\
									for x in e[2:]])
			else:
				r = AstExpression([e[0]] + [_pos_normal_form(x, False, variables,\
							constants, definitions) for x in e[1:]])
	
	return r


def _subformula_cb(expr, _, (subexp, next_index, name2num)):
	if isinstance(expr, AstExpression) and expr[0] in OPS:
		assert len(expr) in [2,3,4]
		outer = SUBEXPRESSION % next_index[0]
		vouter = Variable(outer, BOOLEAN)
		name2num[outer] = next_index[0]
		next_index[0] += 1
		inner = SUBEXPRESSION % next_index[0]
		vinner = Variable(inner, BOOLEAN)
		name2num[inner] = next_index[0]
		next_index[0] += 1
		if len(expr) > 2:
			inner2 = SUBEXPRESSION % next_index[0]
			vinner2 = Variable(inner2, BOOLEAN)
			name2num[inner2] = next_index[0]
			next_index[0] += 1
		
		if len(expr) > 2:
			if len(expr) > 3:
				assert expr[0] in TIMED_OPS
				subexp[outer] = AstExpression(expr[0], expr[1], vinner, vinner2)
			else:
				if expr[0] in TIMED_OPS:
					subexp[outer] = AstExpression(expr[0], expr[1], vinner)
				else:
					subexp[outer] = AstExpression(expr[0], vinner, vinner2)
		else:
			subexp[outer] = AstExpression(expr[0], vinner)
		
		
		if len(expr) > 3:
			assert expr[0] in TIMED_OPS
			subexp[inner] = expr[2].traverse_and_replace(_subformula_cb, \
							(subexp, next_index, name2num))
			subexp[inner2] = expr[3].traverse_and_replace(_subformula_cb, \
							(subexp, next_index, name2num))
		else:
			if len(expr) == 3 and expr[0] in TIMED_OPS:
				subexp[inner] = expr[2].traverse_and_replace(_subformula_cb, \
								(subexp, next_index, name2num))
			else:
				subexp[inner] = expr[1].traverse_and_replace(_subformula_cb, \
								(subexp, next_index, name2num))
			
				if len(expr) > 2:
					subexp[inner2] = expr[2].traverse_and_replace(_subformula_cb,\
								(subexp, next_index, name2num))
		
		return AstExpression(outer)
	else:
		return None

def split_to_subformulas(expr):
	subexp = {}
	name2num = {}
	var = expr.traverse_and_replace(_subformula_cb, (subexp, [0], name2num))
	return var, subexp, name2num

def encode_single_layer_mitl(out, expr, idx, variables, clockmax):
	'Returns: initial constraints, invariant constraints, transition constraints,\
	fairness constraints'
	assert isinstance(expr, AstExpression)
	assert expr[0] in OPS
	assert not expr[0] in LTL_OPS
	assert isinstance(out, Variable)
	assert out.type == BOOLEAN
	assert names.OPEN in variables
	assert out.name in variables
	assert DELTAVAR_NAME in variables
	assert variables[DELTAVAR_NAME] == REAL
	
#	suffix = '-%d' % idx
	opn   = names.OPEN
	opn = Variable(opn, BOOLEAN)
	opnprime = Variable(opn.name + preproc.PRIME_SUFFIX, opn.type)
	obl   = OBLIGATION % idx
	obl = Variable(obl, BOOLEAN)
	oblprime = Variable(obl.name + preproc.PRIME_SUFFIX, obl.type)
	reset = RESET % idx
	reset = Variable(reset, BOOLEAN)
	clk   = CLOCK % idx
	clk = Variable(clk, REAL)
	clkprime = Variable(clk.name + preproc.PRIME_SUFFIX, clk.type)
	clki = Variable(clk.name + INT_SUFFIX, INTEGER)
	clkf = Variable(clk.name + FRAC_SUFFIX, BOOLEAN)
	clkiprime = Variable(clki.name + PRIME_SUFFIX, clki.type)
	clkfprime = Variable(clkf.name + PRIME_SUFFIX, clkf.type)
	rhat  = RIGHTHAT % idx
	rhat = Variable(rhat, BOOLEAN)
	rhatprime = Variable(rhat.name + preproc.PRIME_SUFFIX, rhat.type)
	outprime = Variable(out.name + preproc.PRIME_SUFFIX, out.type)
	timing = TIMING % idx
	timing = Variable(timing, BOOLEAN)
	lefto = LEFT_OPEN % idx
	lefto = Variable(lefto, BOOLEAN)
	leftoprime = Variable(lefto.name + preproc.PRIME_SUFFIX, lefto.type)
	righto = RIGHT_OPEN % idx
	righto = Variable(righto, BOOLEAN)
	rightoprime = Variable(righto.name + preproc.PRIME_SUFFIX, righto.type)
	delta = Variable(DELTAVAR_NAME, REAL)
	deltai = Variable(DELTA_INT, INTEGER)
	deltaf = Variable(DELTA_FRAC, REAL)
	deltaprime = Variable(delta.name + preproc.PRIME_SUFFIX, delta.type)
	deltaiprime = Variable(deltai.name + PRIME_SUFFIX, deltai.type)
	deltafprime = Variable(deltaf.name + PRIME_SUFFIX, deltaf.type)
	zero = Number(0)
	one = Number(1)
	
	addo = E('?:', ('>=', ('+', clkf, deltaf), one), one, zero)
	clockplusdeltai = E('+', ('+', clki, deltai), addo)
	clockplusdeltaf = E('-', ('+', clkf, deltaf), addo)
	
	twoDeltaFSum = E('+', ('+', clkf, deltaf), deltafprime)
	two = Number(2)
	twoDeltaAddO = E('?:',
						('>=', twoDeltaFSum, two),
						two,
						('?:', ('>=', twoDeltaFSum, one), one, zero))
	clockplusdeltaplusdeltaprimei = E('+',
						('+', clki, deltai),
						('+', deltaiprime, twoDeltaAddO))
	clockplusdeltaplusdeltaprimef = E('+',
						('+', clkf, deltaf),
						('-', deltafprime, twoDeltaAddO))
	
	if expr[0] in ['SU', 'SR']:
		left = expr[1]
		right = expr[2]
		assert isinstance(left, Variable)
		assert left.type == BOOLEAN
		assert isinstance(right, Variable)
		assert right.type == BOOLEAN
		leftprime = Variable(left.name + preproc.PRIME_SUFFIX, left.type)
		rightprime = Variable(right.name + preproc.PRIME_SUFFIX, right.type)
	elif expr[0] in ['FLZ', 'GLZ']:
		right = expr[1]
		assert isinstance(right, Variable)
		assert right.type == BOOLEAN
		rightprime = Variable(right.name + preproc.PRIME_SUFFIX, right.type)
	elif expr[0] in ['FLE', 'FLT', 'GLE', 'GLT']:
		const = expr[1]
		right = expr[2]
		assert isinstance(right, Variable)
		assert isinstance(const, Number), (str(const), type(const))
		rightprime = Variable(right.name + preproc.PRIME_SUFFIX, right.type)
	else:
		assert expr[0] in ['UGE', 'UGT', 'RGE', 'RGT']
		const = expr[1]
		left = expr[2]
		right = expr[3]
		assert isinstance(left, Variable)
		assert left.type == BOOLEAN
		assert isinstance(right, Variable)
		assert right.type == BOOLEAN
		assert isinstance(const, Number), (str(const), type(const))
		leftprime = Variable(left.name + preproc.PRIME_SUFFIX, left.type)
		rightprime = Variable(right.name + preproc.PRIME_SUFFIX, right.type)
	
	initial = []
	initial = []
	invar = []
	trans = []
	fairness = []
	newvars = []
	if expr[0] == 'SU':
		trans = [
				E('->',
					('&', out, opn),
					('&', left, ('|', right, ('|', rightprime, ('&', leftprime, outprime))))),
				E('->',
					('&', out, ('!', opn)),
					('|',
						('&', ('!', opnprime), rightprime),
						('&', leftprime, outprime)))
			]
		fairness = [
				E('|', ('!', out), right)
			]
	elif expr[0] == 'FLZ':
		trans = [
				E('->',
					out,
					('&', ('!', opn), ('&', ('!', opnprime), ('|', rightprime, outprime))))
			]
	elif expr[0] in ['FLT', 'FLE']:
		initial = [
				E('=', clk, zero),
				E('!', lefto)
			]
		invar = [
				E('->',
					('&', out, ('!', ('&', right, opn))),
					timing)
			]
		trans = [
				E('->',
					('&', out, opn),
					('|', right, ('|', rightprime, outprime))),
				E('->',
					('&', out, ('!', opn)),
					('|', rightprime, outprime)),
				E('<->',
					reset,
					('&',
						('|',
							('!', out),
							('|',
								('&', opn, right),
								rightprime)),
						outprime)),
				E('->',
					reset,
					('&',
						('=', clkiprime, Number(0)),
						('=', clkfprime, Number(0)))),
				E('->',
					reset,
					('<->', leftoprime, opnprime)),
				E('->',
					('!', reset),
					('&',
						('=', clkiprime, clockplusdeltai),
						('=', clkfprime, clockplusdeltaf))),
				E('->',
					('!', reset),
					('<->', leftoprime, lefto))
			]
		clkplusdelta_LESS_const = E('<', clockplusdeltai, const)
		clkplusdelta_EQ_const = E('&',
			('=', clockplusdeltai, const),
			('=', clockplusdeltaf, zero))
		clkplusdelta_LEQ_const = E('|', clkplusdelta_LESS_const, clkplusdelta_EQ_const)
		if expr[0][2] == 'T':
			invar.append(E('<->',
					timing,
					('|',
						clkplusdelta_LESS_const,
						('&', lefto, clkplusdelta_LEQ_const))))
		else:
			assert expr[0][2] == 'E'
			trans.append(E('<->',
					timing,
					('|',
						clkplusdelta_LESS_const,
						('&',
							('|', ('!', opnprime), lefto),
							clkplusdelta_LEQ_const))))
		newvars = [reset, clk, lefto, timing]
	elif expr[0] in ['UGE', 'UGT']:
		invar = [
				E('<->', rhat, ('&', right, timing)),
				E('->', out, obl),
				E('<->', reset, out)
			]
		trans = [
				E('->',
					('&', obl, opn),
					('&', left,
						('|', rhat, ('|', rhatprime, ('&', leftprime, oblprime))))),
				E('->',
					('&', obl, ('!', opn)),
					('|',
						('&', ('!', opnprime), rhatprime),
						('&', leftprime, oblprime))),
				E('->',
					reset,
					('&',
						('=', clkiprime, Number(0)),
						('=', clkfprime, Number(0)))),
				E('->', reset, ('<->', rightoprime, opn)),
				E('->',
					('!', reset),
					('&',
						('=', clkiprime, clockplusdeltai),
						('=', clkfprime, clockplusdeltaf))),
				E('->', ('!', reset), ('<->', rightoprime, righto))
			]
		clkplusdelta_GE_const = E('>=', clockplusdeltai, const)
		clkplusdelta_GREATER_const = E('|',
				('>', clockplusdeltai, const),
				('&', ('=', clockplusdeltai, const), ('>', clockplusdeltaf, zero)))
		if expr[0][2] == 'T':
			invar.append(E('<->',
					timing,
					('|',
						clkplusdelta_GREATER_const,
						('&',
							righto,
							clkplusdelta_GREATER_const))))
		else:
			assert expr[0][2] == 'E'
			invar.append(E('<->',
					timing,
					('|',
						clkplusdelta_GREATER_const,
						('&',
							('|', righto, ('!', opn)),
							clkplusdelta_GE_const))))
		fairness = [
				E('|', ('!', obl), right)
			]
		newvars = [reset, clk, righto, timing, rhat, obl]
	elif expr[0] == 'GLZ':
		trans = [
				E('->',
					out,
					('|', opn, ('|', opnprime, ('&', rightprime, outprime))))
			]			
	elif expr[0] == 'SR':
		invar = [
				E('->', ('&', out, opn), obl),
				E('->', obl, ('|', ('&', opn, left), right))
			]
		trans = [
				E('->', ('&', out, ('!', opn)), oblprime),
				E('->', obl, ('|', left, oblprime))
			]
		newvars = [obl]
	elif expr[0] in ['GLT', 'GLE']:
		initial = [E('>', clk, const)]
		invar = [
				E('->', ('&', out, opn), right),
				E('->', timing, right)
			]
		trans = [
				E('->',
					out,
					('&',
						('=', clkiprime, Number(0)),
						('=', clkfprime, Number(0)))),
				E('->',
					out,
					('<->', rightoprime, opn)),
				E('->',
					('!', out),
					('&',
						('=', clkiprime, clockplusdeltai),
						('=', clkfprime, clockplusdeltaf))),
				E('->',
					('!', out),
					('<->', rightoprime, righto))
			]
		if expr[0][2] == 'T':
			invar.append(E('<->', timing, ('<', clk, const)))
		else:
			assert expr[0][2] == 'E'
			invar.append(
					E('<->',
						timing,
						('|',
							('<', clk, const),
							('&',
								('<=', clk, const),
								('&', ('!', opn), ('!', righto))))))
		newvars = [clk, righto, timing]
	elif expr[0] in ['RGE', 'RGT']:
		initial = [
				E('=', clk, Number(0)),
				E('!', lefto)
			]
		invar = [
				E('->',
					('&',
						out,
						('>', delta, const)),
					('|', left, right)),
				E('->',
					('&', out, opn),
					obl)
			]
		trans = [
				E('->',
					('&', out, ('!', opn)),
					oblprime),
				E('->',
					obl,
					('|', left, oblprime)),
				E('->',
					('&', oblprime, timing),
					('|', ('&', leftprime, opnprime), rightprime)),
				E('<->',
					reset,
					('&',
						outprime,
						('|',
							('|',
								('!', obl),
								('&',
									left,
									('|', opn, ('!', out)))),
							leftprime))),
				E('->',
					reset,
					('&',
						('=', clkiprime, Number(0)),
						('=', clkfprime, Number(0)))),
				E('->',
					reset,
					('<->', leftoprime, opnprime)),
				E('->',
					('!', reset),
					('&',
						('=', clkiprime, clockplusdeltai),
						('=', clkfprime, clockplusdeltaf))),
				E('->',
					('!', reset),
					('<->', leftoprime, lefto))
			]
		geq = E('>=', clockplusdeltaplusdeltaprimei, const)
		greater = E('|',
			('>', clockplusdeltaplusdeltaprimei, const),
			('&',
				('=', clockplusdeltaplusdeltaprimei, const),
				('>', clockplusdeltaplusdeltaprimef, zero)))
		if expr[0][2] == 'T':
			trans.append(E('<->',
					timing,
					('|',
						greater,
						('&',
							('!', lefto),
							('&',
								('!', opnprime),
								geq)))))
		else:
			assert expr[0][2] == 'E'
			trans.append(E('<->',
					timing,
					greater)),
		newvars = [clk, obl, timing, reset, lefto]
	else:
		assert False
		
	for v in newvars:
		assert isinstance(v, Variable)
		assert not v.name in variables
		variables[v.name] = v.type
	
	if clk in newvars:
		newclocks = [clk]
		clockmax[clk.name] = const.value + 1
	else:
		newclocks = []
	
	return initial, invar, trans, fairness, newclocks, newvars

def _var_to_ast_cb(expr, _, __):
	if isinstance(expr, Variable):
		return AstExpression(expr.name)

def split_all(lst, variables, defnames, constants, clocks):
	for i in xrange(len(lst)):
		expr = lst[i]
		expr = expr.traverse_and_replace(_var_to_ast_cb, None)
		expr = brind.split_clock_comparisons(variables, defnames, constants, expr, '', clocks)
		lst[i] = expr

def encode_neg_mitl(prop, variables, constants, definitions):
	nprop = positive_normal_form(E('!', prop), variables, constants, definitions)
	nprop = simplify(nprop)
	rexpr, subexp, name2num = split_to_subformulas(nprop)
	
	for k in subexp:
		variables[k] = BOOLEAN
		variables[k + PRIME_SUFFIX] = BOOLEAN
	
	initial = [rexpr]
	invar = []
	trans = []
	fairness = []
	defnames = set(x[0] for x in definitions)
	clockmax = {}
	svars = subexp.keys()
	for k, val in subexp.iteritems():
		if isinstance(val, AstExpression) and val[0] in OPS:
			ci, cinv, ct, cf, cclks, cvars =                     \
					encode_single_layer_mitl(Variable(k, BOOLEAN),\
						val, name2num[k], variables, clockmax)
			for v in cvars:
				pn = v.name + preproc.PRIME_SUFFIX
				variables[pn] = v.type
				if not v.name in clockmax:
					svars.append(v.name)
			if cclks:
				for clk in copy.copy(cclks):
					pn = clk.name + preproc.PRIME_SUFFIX
					variables[pn] = clk.type
					cclks.append(Variable(pn, clk.type))
					variables[clk.name + INT_SUFFIX] = INTEGER
					variables[clk.name + FRAC_SUFFIX] = REAL
					variables[clk.name + INT_SUFFIX + PRIME_SUFFIX] = INTEGER
					variables[clk.name + FRAC_SUFFIX + PRIME_SUFFIX] = REAL
				clknames = [clk.name for clk in cclks]
				split_all(ci, variables, defnames, constants, clknames)
				split_all(cinv, variables, defnames, constants, clknames)
				split_all(ct, variables, defnames, constants, clknames)
				split_all(cf, variables, defnames, constants, clknames)
				for clk in cclks:
					del variables[clk.name]
			initial += ci
			invar += cinv
			trans += ct
			fairness += cf
		else:
			invar.append(E('<->', Variable(k, BOOLEAN), val))
	
	comments = '\n'.join('%s : %s' % x for x in subexp.iteritems())
	
	return initial, invar, trans, fairness, svars, clockmax, comments

if __name__ == "__main__":
	import nusmv_yacc, sys
	if len(sys.argv) <= 1:
		print 'No arguments'
	else:
		arg = ' '.join(sys.argv[1:])
		print arg
		expr = nusmv_yacc.mitl_expression_parser.parse(arg)
		print 'EXP:', str(expr)
		vrs = {}
		for i in xrange(26):
			v = chr(ord('a') + i)
			vrs[v] = BOOLEAN
		vrs[OPEN] = BOOLEAN
		vrs[OPEN + PRIME_SUFFIX] = BOOLEAN
		vrs[DELTAVAR_NAME] = REAL
		vrs[DELTA_INT] = INTEGER
		vrs[DELTA_FRAC] = REAL
		vrs[DELTAVAR_NAME + preproc.PRIME_SUFFIX] = REAL
		vrs[DELTA_INT + preproc.PRIME_SUFFIX] = INTEGER
		vrs[DELTA_FRAC + preproc.PRIME_SUFFIX] = REAL
		print 'SIM:', simplify(expr)
		print 'PNF:', positive_normal_form(AstExpression('!', expr), vrs, [], [])
		print
		
#		rexpr, subexp, name2num = split_to_subformulas(simplify(expr))
#		print 'Split:'
#		print '   ', rexpr
#		
#		for k in subexp:
#			vrs[k] = BOOLEAN
#		
#		for k, v in subexp.iteritems():
#			print
#			print k, '(', name2num[k], ')', ':', v
#			if isinstance(v, AstExpression) and v[0] in OPS:
#				print 'Encoding:'
#				initial, invar, trans, fairness = encode_single_layer_mitl(Variable(k, BOOLEAN),\
#							v, name2num[k], vrs)
#				if initial:
#					print 'Initial:'
#					for intl in initial:
#						print '   ', intl
#				if invar:
#					print 'Invars:'
#					for inv in invar:
#						print '   ', inv
#				if trans:
#					print 'Trans:'
#					for t in trans:
#						print '   ', t
#				if fairness:
#					print 'Fairness:'
#					for f in fairness:
#						print '   ', f
#			else:
#				print '   ', AstExpression('<->', Variable(k, BOOLEAN), v)
#		print
#		print 'Variables:'
#		for k, v in vrs.iteritems():
#			if not (len(k) == 1 and ord(k) >= ord('a') and ord(k) <= ord('z')):
#				print k, ':', v	
#		print 
#		print
		oldvrs = copy.copy(vrs)
		
		initial, invar, trans, fairness, svars, clockmax, comments = \
										encode_neg_mitl(expr, vrs, [], [])
		print 'Initial:'
		if initial:
			for c in initial:
				print '   ', c
		else:
			print '   ', '  N O N E'
		
		print 'Invar:'
		if invar:
			for c in invar:
				print '   ', c
		else:
			print '   ', '  N O N E'
		
		print 'Trans:'
		if trans:
			for c in trans:
				print '   ', c
		else:
			print '   ', '  N O N E'
		
		print 'Fairness:'
		if fairness:
			for c in fairness:
				print '   ', c
		else:
			print '   ', '  N O N E'
		
		print
		
		print 'Statevars:', ' '.join(svars)
		print
		
		print 'Clockmax:'
		for k, v in clockmax.iteritems():
			print '   ', k, v
		print
		
		for k, v in vrs.iteritems():
			if k in oldvrs:
				assert vrs[k] == oldvrs[k]
			else:
				print k, ':', v
		print
		print

