#!/usr/bin/python -O

#TODO: check INT_FRAC_SPLIT stuff not done for non-clock models
#TODO: check: definition using transdef becomes transdef itself
#TODO: Output method used
#TODO: encforce no primed clocks

import config

if __name__ == '__main__':
	config.parse_command_line()

################################################################################
PRINT_SKIPS = False

### Debugging -- by default everything should be False
_DEBUG_DONT_COUNT_CLAUSES      = False
_DEBUG_SKIP_DUPLICATE_CHECKING = False
_DEBUG_DUMP_TRACE              = False
_DEBUG_PROFILE                 = False

### Variable names; Note that meta variable names should contain dashes, as they are not permitted as parts of variable names in the NuSMV format and therefore prevent name collisions
import names
from names import DELTAVAR_NAME, INT_SUFFIX, FRAC_SUFFIX, INCREASE_PREFIX, DELTA_FRAC, DELTA_INT

################################################################################
import os, sys, getopt, heapq, copy, random, copy
import preproc, expressions, states, yutil, colors, nusmv_yacc, stats, cseq, yicesfull, interactive, unrolling, nusmv_lex, unrolling
import ltbmc

if _DEBUG_DUMP_TRACE:
	_dbg_tracef = open('_brind_trace', 'w')
	def _dbg_trace(frame, event, arg):
		_dbg_tracef.write('%s, %s:%d\n' % (event, frame.f_code.co_filename, frame.f_lineno))
		_dbg_tracef.flush()
		return _dbg_trace
	sys.settrace(_dbg_trace)

################################################################################
# Error handling

ERR_INVALID_MODEL = 2

class BrindException(Exception):
	'For general exceptions'
	pass

class TerminateException(Exception):
	'Used to indicate an error message should be printed to stderr and then the' \
	'program terminated with an error code'
	def __init__(self, retval, msg):
		self.retval = retval
		self.msg = msg

OP_REVERSE = {
	'<' : '>',
	'<=' : '>=',
	'>' : '<',
	'>=' : '<=',
	'=' : '='
}

@preproc.RewriteExpr(False, False, True)
def split_clock_comparisons(surrounding, expr, prefix, is_def, clocks):
	assert isinstance(expr, expressions.AstExpression)
	assert len(expr) > 1
		
	if len(expr) != 3:
		return None
		
	if isinstance(expr[1], expressions.AstExpression)\
			and len(expr[1]) == 1                     \
			and expr[1][0] in clocks:
		pos = 1
		op = expr[0]
	elif isinstance(expr[2], expressions.AstExpression)\
			and len(expr[2]) == 2                        \
			and expr[2][0] in clocks:
		pos = 2
		op = OP_REVERSE[expr[0]]
	else:
		return None
	
	assert op in OP_REVERSE, (op, str(surrounding), str(expr))
	assert isinstance(expr[3 - pos], expressions.Number), (str(expr), str(expr[3 - pos]), type(expr[3 - pos]))
	clk = expr[pos][0]
	const = expr[3 - pos]
	
	if clk.endswith(preproc.PRIME_SUFFIX):
		clb = clk[:-len(preproc.PRIME_SUFFIX)]
		cli = clb + INT_SUFFIX + preproc.PRIME_SUFFIX
		clf = clb + INT_SUFFIX + preproc.PRIME_SUFFIX
	else:
		cli = clk + INT_SUFFIX
		clf = clk + FRAC_SUFFIX
	
	if op == '<':
		return expressions.AstExpression('<', cli, const)
	if op == '<=':
		return expressions.AstExpression('|', ('<', cli, const), ('&', ('=', cli, const), ('=', clf, expressions.ZERO)))
	if op == '>':
		return expressions.AstExpression('|', ('>', cli, const), ('&', ('=', cli, const), ('>', clf, expressions.ZERO)))
	if op == '>=':
		return expressions.AstExpression('>=', cli, const)
	if op == '=':
		return expressions.AstExpression('&', ('=', cli, const), ('=', clf, expressions.ZERO))
	else:
		assert False

################################################################################
############################## Bradley induction ###############################
################################################################################

class BradleyInduction(object):
	#Configuration
	EXCEPTION_TYPE     = BrindException #Used for exceptions
	yices_exec         = False          #Don't use yices as executable
	definitions        = None           # List of (name, expression) pairs in viable inlining order
	
	#Constructor
	def __init__(self, model):
		if config.use_k_ind:
			self.cls = unrolling.TemporalInduction
		elif config.ltl_bmc_bound != None or (config.list_properties and config.list_ltl) or config.count_ltl_properties:
			self.cls = ltbmc.LTBMC
		elif config.mitl_count or config.mitl_list or config.mitl_bound != None:
			import mitlbmc
			self.cls = mitlbmc.MITLBMC
		elif config.bmc_bound != None:
			self.cls = unrolling.BMC
		else:
			self.cls = cseq.ClauseSequence
		
		self._init(model)
		self._generate_initial()
#		print 'KOIRA'
#		print 'Intials:'
#		for x in self.initials:
#			print x
#		print
#		for x in self.xinitials:
#			print x
#		print
#		print
		self._generate_invar()
#		print 'Invars:'
#		for x in self.invariants:
#			print x
#		print
#		for x in self.xinvariants:
#			print x
#		print
#		print
		self._generate_transition()
#		print 'Trans:'
#		for x in self.transitions:
#			print x
#		print
#		print
#		print 'Defs:'
#		for a, b in self.definitions:
#			print a, ':', b
#		print
#		print 'Variables:'
#		for a, b in self.variables.iteritems():
#			print a, ':', b
#		print
	
	def _init(self, model):#, spec_preproc_cb):
		'Initialize members: module, orgspecs, specs, clocks, clockmax, variables, used_types\n'\
		'Checks convexity if required\n'                                                         \
		'spec_preproc_cb should take one specification as an argument, and'                       \
		'preprocess the specification if supported or return None if it is not'                    \
		'supported'
		# Read model
		(self.variables, self.unprimed_vars, self.definition_vars),                         \
				(self.definitions, self.transition_definitions),                             \
				(self.initials, self.xinitials, self.transitions, self.invariants,            \
				self.xinvariants, self.urgencies, self.resets, self.property, self.xproperty), \
				self.orgspecs, self.clockmax =                                                  \
					preproc.preprocess(model, config.type_check, config.def_vars, config.check_property,
										self.cls.FULL_XINVARIANT, False, spectype=self.cls.SPECTYPE)
		
		# Allocate constants
		self.constants = []
		for t in self.variables.itervalues():
			if isinstance(t, expressions.Enumeration):
				for v in t.values:
					if not v in self.constants:
						self.constants.append(v)
		
		# Convexity
		if not config.nochecks:
			for invar in self.invariants:
				(conv, mdl) = yutil.is_convex(self.variables, self.constants, self.definitions, invar)
				if not conv:
					raise TerminateException(ERR_INVALID_MODEL, 'Non-convex invariant: %s' % str(invar))
		
		# Split up comparisons
		if self.cls.INT_FRAC_SPLIT: #self.variables, self.unprimed_vars, self.definition_vars
			defnames = set(x[0] for x in self.definitions)
			clocks = set(self.resets)
			clocks.update(x + preproc.PRIME_SUFFIX for x in self.resets)
			for i in xrange(len(self.definitions)):
				dn, expr = self.definitions[i]
				self.definitions[i] = dn, split_clock_comparisons(self.variables, defnames, self.constants, expr, '', clocks)
			
			for lst in [self.initials, self.xinitials, self.transitions, self.invariants, self.xinvariants, self.urgencies]:
				for i in xrange(len(lst)):
					lst[i] = split_clock_comparisons(self.variables, defnames, self.constants, lst[i], '', clocks)
			
			self.property = split_clock_comparisons(self.variables, defnames, self.constants, self.property, '', clocks)
			self.xproperty = split_clock_comparisons(self.variables, defnames, self.constants, self.xproperty, '', clocks)
			
			for clk, expr in self.resets.items():
				self.resets[clk] = split_clock_comparisons(self.variables, defnames, self.constants, expr, '', clocks)
	
	#Generate relations
	def _generate_initial(self):
		if self.cls.COMBINED_TRANS:
			if self.resets:
				clks = self.resets.keys()
				if self.cls.INT_FRAC_SPLIT:
					clk0i = clks[0] + INT_SUFFIX
					clk0f = clks[0] + FRAC_SUFFIX
				else:
					clk0 = clks[0]
				for clkname in clks[1:]:
					if self.cls.INT_FRAC_SPLIT:
						self.initials.append(expressions.AstExpression('=',
								clkname + INT_SUFFIX,
								clk0i))
						self.initials.append(expressions.AstExpression('=',
								clkname + FRAC_SUFFIX,
								clk0f))
						self.xinitials.append(expressions.AstExpression('=',
								clkname + INT_SUFFIX  + preproc.PRIME_SUFFIX,
								clk0i))
						self.xinitials.append(expressions.AstExpression('=',
								clkname + FRAC_SUFFIX + preproc.PRIME_SUFFIX,
								clk0f))
					else:
						self.initials.append(expressions.AstExpression('=', 
								clkname,
								clk0))
						self.xinitials.append(expressions.AstExpression('=',
								clkname + preproc.PRIME_SUFFIX,
								clk0))
				#NOTE: c >= 0 is already in invariant
		elif self.cls.INTERVAL_TRANS:
			assert self.cls.INT_FRAC_SPLIT
			clks = self.resets.keys()
			nw = []
			zero = expressions.Number(0)
			for clkname in clks:
				nw.append(expressions.AstExpression('=', clkname + INT_SUFFIX, zero))
				nw.append(expressions.AstExpression('=', clkname + FRAC_SUFFIX, zero))
			nw.append(expressions.AstExpression('!', names.OPEN))
			self.initials += nw
			
			vrs = copy.copy(self.variables)
			vrs[names.OPEN] = expressions.BOOLEAN
			vrs[names.OPEN + preproc.PRIME_SUFFIX] = expressions.BOOLEAN
			vrs[names.DELTAVAR_NAME] = expressions.REAL
			for clkname in self.resets:
				vrs[clkname + INT_SUFFIX] = expressions.INTEGER
				vrs[clkname + FRAC_SUFFIX] = expressions.REAL
			preproc._prime_expressions(vrs, self.definitions, self.constants, nw, True)
			self.xinitials += nw
		else:
			zero = expressions.Number(0)
			if self.cls.INT_FRAC_SPLIT:
				for clkname in self.resets:
					self.initials.append(expressions.AstExpression('=',
								clkname + INT_SUFFIX,
								zero))
					self.initials.append(expressions.AstExpression('=',
								clkname + FRAC_SUFFIX,
								zero))
					self.xinitials.append(expressions.AstExpression('=',
								clkname + preproc.PRIME_SUFFIX,
								zero))
					self.xinitials.append(expressions.AstExpression('=',
								clkname + preproc.PRIME_SUFFIX,
								zero))
			else:
				for clkname in self.resets:
					self.initials.append(expressions.AstExpression('=',
								clkname,
								zero))
					self.xinitials.append(expressions.AstExpression('=',
								clkname + preproc.PRIME_SUFFIX,
								zero))
	
	def _generate_invar(self):
		if self.cls.INTERVAL_TRANS:
			assert self.cls.INT_FRAC_SPLIT
			clks = self.resets.keys()
			nw = []
			zero = expressions.Number(0)
			for clkname in clks:
				nw.append(expressions.AstExpression('>=', clkname, zero))
			
			vrs = copy.copy(self.variables)
			vrs[names.OPEN] = expressions.BOOLEAN
			vrs[names.OPEN] = expressions.BOOLEAN
			vrs[names.DELTAVAR_NAME] = expressions.REAL
			for clkname in self.resets:
				vrs[clkname + INT_SUFFIX] = expressions.INTEGER
				vrs[clkname + FRAC_SUFFIX] = expressions.REAL
			
			defnames = set(x[0] for x in self.definitions)
			for i in xrange(len(nw)):
				nw[i] = split_clock_comparisons(vrs, defnames, self.constants,
														nw[i], '', self.resets)
			
			nw.append(expressions.AstExpression('<->',
					names.OPEN,
					('|',
						('!=', names.DELTA_INT, zero),
						('!=', names.DELTA_FRAC, zero))))
			
			one = expressions.Number(1)
			for clkname in self.resets:
				fname = clkname + FRAC_SUFFIX
				nw.append(expressions.AstExpression('>=', fname, zero))
				nw.append(expressions.AstExpression('<', fname, one))
			nw.append(expressions.AstExpression('>=', DELTA_INT, zero))
			nw.append(expressions.AstExpression('>=', DELTA_FRAC, zero))
			nw.append(expressions.AstExpression('<', DELTA_FRAC, one))
			vrs[DELTA_FRAC] = expressions.REAL
			vrs[DELTA_INT] = expressions.INTEGER
			
			self.invariants += nw
			
			preproc._prime_expressions(vrs, self.definitions, self.constants, nw, True)
			self.xinvariants += nw
		else:
			if self.resets:
				zero = expressions.Number(0)
				if self.cls.INT_FRAC_SPLIT:
					one = expressions.Number(1)
				for clk in self.resets: # NOTE: we're adding this for making
				                        # backward search more reasonable
					if self.cls.INT_FRAC_SPLIT:
						clki = clk + INT_SUFFIX
						clkf = clk + FRAC_SUFFIX
						xclki = clk + INT_SUFFIX  + preproc.PRIME_SUFFIX
						xclkf = clk + FRAC_SUFFIX + preproc.PRIME_SUFFIX
						self.invariants.append(expressions.AstExpression('>=',  clki,  zero))
						self.invariants.append(expressions.AstExpression('>=',  clkf,  zero))
						self.invariants.append(expressions.AstExpression('<',   clkf,  one))
						self.xinvariants.append(expressions.AstExpression('>=', xclki, zero))
						self.xinvariants.append(expressions.AstExpression('>=', xclkf, zero))
						self.xinvariants.append(expressions.AstExpression('<',  xclkf, one))
						if self.cls.BOUND_INT_VAR:
							self.invariants.append(expressions.AstExpression('<=',
									clki,
									expressions.Number(self.clockmax[clk] + 1)))
							self.xinvariants.append(expressions.AstExpression('<=',
									xclki,
									expressions.Number(self.clockmax[clk] + 1)))
					else:
						self.invariants.append(expressions.AstExpression('>=',  
										clk,
										zero))
						self.xinvariants.append(expressions.AstExpression('>=',
										clk + preproc.PRIME_SUFFIX,
										zero))
	
	def _generate_transition(self):
		if self.cls.COMBINED_TRANS:
			assert not self.cls.INTERVAL_TRANS # Currently not with combined transition relation
			if self.resets:
				# Individual elements
				zero = expressions.Number(0)
				if self.cls.INT_FRAC_SPLIT:
					one = expressions.Number(1)
					for clk in self.resets:
						dn = INCREASE_PREFIX + clk
						self.definitions.append((dn, expressions.AstExpression('?:',
										('>=', ('+', clk + FRAC_SUFFIX, DELTA_FRAC), one),
										one,
										zero)))
						self.transition_definitions.add(dn)
		
					clock_diff_not_reset = []
					clock_diff_reset = []
		
					for (clk, r) in self.resets.iteritems():
						ci = clk + INT_SUFFIX
						xci = clk + INT_SUFFIX + preproc.PRIME_SUFFIX
						cf = clk + FRAC_SUFFIX
						xcf = clk + FRAC_SUFFIX + preproc.PRIME_SUFFIX
						inc = INCREASE_PREFIX + clk
						clock_diff_not_reset.append(expressions.AstExpression('->',
										('!', r),
										('=', xci, ('+', ('+', ci, DELTA_INT), inc))))
						clock_diff_not_reset.append(expressions.AstExpression('->',
										('!', r),
										('=', xcf, ('-', ('+', cf, DELTA_FRAC), inc))))
						clock_diff_reset.append(expressions.AstExpression('->',
										r,
										('=', xci, ('+', DELTA_INT, inc))))
						clock_diff_reset.append(expressions.AstExpression('->',
										r,
										('=', xcf, ('-', DELTA_FRAC, inc))))
		
					urgent_no_delay      = [expressions.AstExpression('->', u, ('=', DELTA_INT,  zero))
												for u in self.urgencies] +\
								           [expressions.AstExpression('->', u, ('=', DELTA_FRAC, zero))
								           		for u in self.urgencies]
		
					delta_pos            = [expressions.AstExpression('>=', DELTA_INT,  zero),
								            expressions.AstExpression('>=', DELTA_FRAC, zero),
								            expressions.AstExpression('<', DELTA_FRAC, expressions.Number(1))]
		
				else:
					clock_diff_not_reset = []
					clock_diff_reset = []
					for (clk, r) in self.resets.iteritems():
						clock_diff_not_reset.append(expressions.AstExpression('->',
										('!', r),
										('=', clk + preproc.PRIME_SUFFIX, ('+', clk, DELTAVAR_NAME))))
						clock_diff_reset.append(    expressions.AstExpression('->',
										r,
										('=', clk + preproc.PRIME_SUFFIX, DELTAVAR_NAME)))
					delta_pos            = [expressions.AstExpression('>=', DELTAVAR_NAME, zero)]
					urgent_no_delay      = [expressions.AstExpression('->', u, ('=', DELTAVAR_NAME, zero))
															for u in self.urgencies]
				
				# Compose
				self.transitions += clock_diff_not_reset + clock_diff_reset + urgent_no_delay + delta_pos
		elif self.cls.INTERVAL_TRANS:
			zero = expressions.Number(0)
			nw = []
			opn = expressions.AstExpression(names.OPEN)
			sing = expressions.AstExpression('!', opn)
			opnprime = expressions.AstExpression(names.OPEN + preproc.PRIME_SUFFIX)
			singprime = expressions.AstExpression('!', opnprime)
			delta = expressions.AstExpression(names.DELTAVAR_NAME)
			disctrans = expressions.AstExpression('&', sing, singprime)
			
			# No open-to-open
			nw.append(expressions.AstExpression('|', sing, singprime))
			
			# Discrete transition:
			for trans in self.transitions:
				nw.append(expressions.AstExpression('->', disctrans, trans))
			
			# Resets:
			for clk, r in self.resets.iteritems():
				nw.append(expressions.AstExpression('->',
					('&', disctrans, r),
					('&', 
						('=', clk + INT_SUFFIX + preproc.PRIME_SUFFIX, zero),
						('=', clk + FRAC_SUFFIX + preproc.PRIME_SUFFIX, zero))))
			
			# Non-resets:
			for clk, r in self.resets.iteritems():
				nw.append(expressions.AstExpression('->',
					('&', disctrans, ('!', r)),
					('&', 
						('=', clk + INT_SUFFIX + preproc.PRIME_SUFFIX, clk + INT_SUFFIX),
						('=', clk + FRAC_SUFFIX + preproc.PRIME_SUFFIX, clk + FRAC_SUFFIX))))
			
			# Open-to-singular or vice versa
			one = expressions.Number(1)
			for clk in self.resets:
				dn = INCREASE_PREFIX + clk
				self.definitions.append((dn, expressions.AstExpression('?:',
								('>=', ('+', clk + FRAC_SUFFIX, DELTA_FRAC), one),
								one,
								zero)))
				self.transition_definitions.add(dn)
			
			for clk in self.resets:
				clkf = clk + FRAC_SUFFIX
				clki = clk + INT_SUFFIX
				dn = INCREASE_PREFIX + clk
				nw.append(expressions.AstExpression('->',
						('|', opn, opnprime),
						('=', clki + preproc.PRIME_SUFFIX, ('+', ('+', clki, DELTA_INT), dn))))
				nw.append(expressions.AstExpression('->',
						('|', opn, opnprime),
						('=', clkf + preproc.PRIME_SUFFIX, ('-', ('+', clkf, DELTA_FRAC), dn))))
			for var in self.variables:
				if not var in self.resets and not var.endswith(preproc.PRIME_SUFFIX):
					nw.append(expressions.AstExpression('->',
							('|', opn, opnprime),
							('=', var + preproc.PRIME_SUFFIX, var)))
			
			self.transitions = nw
		else:
			zero = expressions.Number(0)
			if self.cls.INT_FRAC_SPLIT:
				one = expressions.Number(1)
				for clk in self.resets:
					dn = INCREASE_PREFIX + clk
					self.definitions.append((dn, expressions.AstExpression('?:',
								('>=', ('+', clk + FRAC_SUFFIX, DELTA_FRAC), one),
								one,
								zero)))
					self.transition_definitions.add(dn)
				
				zero = expressions.Number(0)
				delta_pos            = [expressions.AstExpression('|',
												('>', DELTAVAR_NAME + INT_SUFFIX, zero),
												('&',
													('=', DELTAVAR_NAME + INT_SUFFIX, zero),
													('>', DELTAVAR_NAME + FRAC_SUFFIX, zero))
											)]
				delta_zero           = [expressions.AstExpression('&',
												('=', DELTAVAR_NAME + INT_SUFFIX, zero),
												('=', DELTAVAR_NAME + FRAC_SUFFIX, zero))]
				urgent_no_delay      = [expressions.AstExpression('->', u, delta_zero[0]) for u in self.urgencies]
			
				disc_reset =     [expressions.AstExpression('->',       r , ('&',
										('=', clk + INT_SUFFIX + preproc.PRIME_SUFFIX, zero),
										('=', clk + FRAC_SUFFIX + preproc.PRIME_SUFFIX, zero)))
											for clk, r in self.resets.iteritems()]
				disc_non_reset = [expressions.AstExpression('->', ('!', r), ('&',
												('=', clk + INT_SUFFIX + preproc.PRIME_SUFFIX, clk + INT_SUFFIX),
												('=', clk + FRAC_SUFFIX + preproc.PRIME_SUFFIX, clk + FRAC_SUFFIX)))
											for clk, r in self.resets.iteritems()]
				discrete_step = self.transitions + disc_reset + disc_non_reset + delta_zero
			
				no_var_change = [expressions.AstExpression('=', v + preproc.PRIME_SUFFIX, v)
											for v, t in self.variables.iteritems()
												if t != expressions.REAL and not v.endswith(preproc.PRIME_SUFFIX)]
				no_clock_change = [expressions.AstExpression('&',
												('=', clk + INT_SUFFIX + preproc.PRIME_SUFFIX, clk + INT_SUFFIX),
												('=', clk + FRAC_SUFFIX + preproc.PRIME_SUFFIX, clk + FRAC_SUFFIX))
											for clk, r in self.resets.iteritems()]
				
				clock_diff = []
				for clk in self.resets:
					if not self.cls.BOUND_INT_VAR:
						clock_diff.append(expressions.AstExpression('=', clk + INT_SUFFIX + preproc.PRIME_SUFFIX,
												('+',
													('+',
														clk + INT_SUFFIX,
														DELTAVAR_NAME + INT_SUFFIX
													),
													INCREASE_PREFIX + clk
												)
											))
					else:
						assert not self.cls.INTERVAL_TRANS # Currently not with bounded variables
						nvl = expressions.AstExpression('+',
													('+',
														clk + INT_SUFFIX,
														DELTAVAR_NAME + INT_SUFFIX
													),
													INCREASE_PREFIX + clk
												)
						mxnm = expressions.Number(self.clockmax[clk])
						mxnmp = expressions.Number(self.clockmax[clk] + 1)
						clock_diff.append(expressions.AstExpression('=',
								clk + INT_SUFFIX + preproc.PRIME_SUFFIX,
								('?:', ('>', nvl, mxnm), mxnmp, nvl)
							))
					
					clock_diff.append(expressions.AstExpression('=', clk + FRAC_SUFFIX + preproc.PRIME_SUFFIX,
											('-',
												('+',
													clk + FRAC_SUFFIX,
													DELTAVAR_NAME + FRAC_SUFFIX
												),
												INCREASE_PREFIX + clk
											)
										))
				elapse_step = no_var_change + clock_diff + delta_pos
				interval_start = no_var_change + no_clock_change + delta_zero
				if self.cls.INTERVAL_TRANS:
					self.transitions = urgent_no_delay + [  # no two consecutive open intervals
								expressions.AstExpression('!', ('&',
										ltbmc.ELAPSE_VAR,
										ltbmc.ELAPSE_VAR + preproc.PRIME_SUFFIX)),
								# end of elapse step
								expressions.AstExpression('->',
									('&', ltbmc.ELAPSE_VAR, ('!', ltbmc.ELAPSE_VAR + preproc.PRIME_SUFFIX)),
									expressions.reduce_to_ast_commutative('&', elapse_step, 'TRUE')
								),
								# start of elapse step
								expressions.AstExpression('->',
									('&', ('!', ltbmc.ELAPSE_VAR), ltbmc.ELAPSE_VAR + preproc.PRIME_SUFFIX),
									expressions.reduce_to_ast_commutative('&', interval_start, 'TRUE')
								),
								expressions.AstExpression('->',
									('&', ('!', ltbmc.ELAPSE_VAR), ('!', ltbmc.ELAPSE_VAR + preproc.PRIME_SUFFIX)),
									expressions.reduce_to_ast_commutative('&', discrete_step, 'TRUE')
															)]
					print '\n\n'.join(map(str, self.transitions))
				else:
					self.transitions = urgent_no_delay + [expressions.AstExpression('&',
												('->',
													('!', ltbmc.ELAPSE_VAR),
													expressions.reduce_to_ast_commutative('&', discrete_step, 'TRUE')),
												('->',
													ltbmc.ELAPSE_VAR,
													expressions.reduce_to_ast_commutative('&', elapse_step, 'TRUE')))]
				
				if self.cls.INT_FRAC_SPLIT:
					self.transitions.append(expressions.AstExpression('>=', DELTA_FRAC, zero))
					self.transitions.append(expressions.AstExpression('<',  DELTA_FRAC, one))
					self.transitions.append(expressions.AstExpression('>=', DELTA_INT,  zero))
					if self.cls.BOUND_INT_VAR:
						mx = max(self.clockmax.itervalues())
						mx = expressions.Number(mx + 1)
						self.transitions.append(expressions.AstExpression('<=', DELTA_INT, mx))
			else:
				assert not self.cls.INT_FRAC_SPLIT
				assert not self.cls.INTERVAL_TRANS # Currently not with mixed type
				zero = expressions.Number(0)
				delta_pos            = [expressions.AstExpression('>', DELTAVAR_NAME, zero)]
				delta_zero           = [expressions.AstExpression('=', DELTAVAR_NAME, zero)]
				urgent_no_delay      = [expressions.AstExpression('->',
												u,
												('=', DELTAVAR_NAME, zero)) for u in self.urgencies]
			
				disc_reset =     [expressions.AstExpression('->',       r , ('=', clk + preproc.PRIME_SUFFIX, zero))
											for clk, r in self.resets.iteritems()]
				disc_non_reset = [expressions.AstExpression('->', ('!', r), ('=', clk + preproc.PRIME_SUFFIX, clk ))
											for clk, r in self.resets.iteritems()]
				discrete_step = self.transitions + disc_reset + disc_non_reset + delta_zero
			
				no_var_change = [expressions.AstExpression('=', v + preproc.PRIME_SUFFIX, v)
										for v, t in self.variables.iteritems()
											if t != expressions.REAL and not v.endswith(preproc.PRIME_SUFFIX)]
				clock_diff = [expressions.AstExpression('=',
							clk + preproc.PRIME_SUFFIX,
							('+', clk, DELTAVAR_NAME)) for clk in self.resets]
				elapse_step = no_var_change + clock_diff + delta_pos
			
				self.transitions = urgent_no_delay + [expressions.AstExpression('&',
											('->',
												('!', ltbmc.ELAPSE_VAR),
												expressions.reduce_to_ast_commutative('&', discrete_step, 'TRUE')),
											('->',
												ltbmc.ELAPSE_VAR,
												expressions.reduce_to_ast_commutative('&', elapse_step, 'TRUE')))]
	
	def verify(self, num, skip):
		global statistics
		assert isinstance(num, (int, long))
				
		if not skip or PRINT_SKIPS:
			print 'Property %d' % num, (colors.bold if skip else colors.bright_blue)(str(self.orgspecs[num][1])),
			if self.orgspecs[num][0]:
				print 'in', self.orgspecs[num][0]
		
		if skip:
			if PRINT_SKIPS:
				print 'was', colors.bold('skipped')
			return None, None
		else:
			#Actual checking
			variables = {}
			for k, v in self.variables.iteritems():
				if k in self.unprimed_vars and not k in self.clockmax:
					variables[k] = v
			special_vars = {}
			if config.def_vars:
				if config.defs_in_clauses:
					for v in self.definition_vars:
						if not v.endswith(preproc.PRIME_SUFFIX):
							variables[v] = self.variables[v]
				else:
					for v in self.definition_vars:
						special_vars[v] = self.variables[v]
			if self.resets or not self.cls.COMBINED_TRANS:
				special_vars[DELTAVAR_NAME] = expressions.REAL
			
			if self.cls.INTERVAL_TRANS:
				special_vars[names.OPEN] = expressions.BOOLEAN
				special_vars[names.OPEN + preproc.PRIME_SUFFIX] = expressions.BOOLEAN
			else:
				if not self.cls.COMBINED_TRANS:
					special_vars[ltbmc.ELAPSE_VAR] = expressions.BOOLEAN
			cs = self.cls(variables,
							self.clockmax,
							special_vars,
							self.constants,
							self.initials,
							self.xinitials,
							self.invariants,
							self.xinvariants,
							self.transitions,
							self.property,
							self.xproperty,
							self.definitions,
							self.transition_definitions,
							statistics)
			statistics.set_cs(cs)
			holds, k, counter = cs.verify()
			statistics.holds = holds
			statistics.k = k
		
			if not holds:
				statistics.ce_length = sum(1 for x in counter if x[0] != None)
				assert isinstance(counter, states.CounterExample)
#				printinfo = '\n' + counter.string('\t', config.short_states)
				printinfo = '\n' + counter.coltable()
			else:
				printinfo = counter
			
			sys.stdout.write(' ')
			if holds:
				if self.cls.COMPLETE:
					sys.stdout.write(colors.green('holds'))
				else:
					sys.stdout.write(colors.yellow('maybe holds'))
			else:
				sys.stdout.write(colors.red('does not hold'))
			if printinfo == None:
				print
			else:
				print ' %s' % printinfo
			return holds, k
	
	def interactive(self): #TODO: make work again
		inter = interactive.Interactor(self.variables,
										self.clockmax,
										nonprimed(self.init, self.prime_constants),
										nonprimed(self.trans, self.prime_constants),
										nonprimed(self.invar, self.prime_constants))
		inter.run()
	
	def speccount(self):
		return len(self.orgspecs)

	def list_specs(self, colored = False):
		for i in xrange(len(self.orgspecs)):
			if self.orgspecs[i][0]:
				print '%-8d %s in %s' % (i, str(self.orgspecs[i][1]), self.orgspecs[i][0])
			else:
				print '%-8d %s' % (i, str(self.orgspecs[i][1]))
			if self.orgspecs[i] == None:
				strn = '         (not supported)'
				if colored:
					print colors.red(strn)
				else:
					print strn
		sys.exit(0)
		
	def count_specs(self, colored = False):
		print len(self.orgspecs)
		sys.exit(0)

def main():
	global statistics
	
	try:
		
		# Model
		statistics = stats.BrindStats()
	
		# Parse file
		inf = open(config.filename, 'r')
		model = nusmv_yacc.parser.parse(inf.read())
		inf.close()
	
		# Actual Checking
		if config.show_stats                    \
				and (not config.count_properties)\
				and (not config.list_properties)  \
				and (not config.count_ltl_properties):
			print 'File:', config.filename
			print 'Verification starting at', statistics.start
			print 'Using yices version', yicesfull.get_version()
		
		try:
			b = BradleyInduction(model)
			
			if config.list_properties:
				b.list_specs()
			elif config.count_properties or config.count_ltl_properties or config.mitl_count:
				b.count_specs()
			elif config.interactive:
				b.interactive()
			else:
				for i in xrange(b.speccount()):
					skip = (not config.check_property in [None, i]) 
					holds, rbound = b.verify(i, skip)
			if config.show_stats:
				print statistics
		finally:
			statistics.write_tr(config.table_row_file)
	except Exception, e:
		if isinstance(e, TerminateException):
			sys.stdout.write('\n')
			sys.stderr.write('ERROR: ')
			sys.stderr.write(e.msg)
			sys.stderr.write('\n')
			sys.exit(e.retval)
		elif isinstance(e, (preproc.PreprocessingException, preproc.TypeException, nusmv_lex.ParsingException)):
			sys.stdout.write('\n')
			sys.stderr.write('ERROR: ')
			sys.stderr.write(str(e))
			sys.stderr.write('\n')
			raise
			sys.exit(ERR_INVALID_MODEL)
		else:
			print
			print '!!!', 'SEED', config.seed, '!!!'
			raise

if __name__ == '__main__':
#	import debugging; debugging.notify_stdout('__class__')
	if _DEBUG_PROFILE:
		import cProfile
		cProfile.run('main()', 'brind_profile')
	else:
		main()

