#ifndef PREFIX_H
#define PREFIX_H

#include <stdio.h>
#include "combi.h"
#include "monset.h"
#include "ulstack.h"
#include "mset.h"
#include "sarray.h"
#include "ptnet.h"
#include "darray.h"
#include "dphash.h"
#include "eventq.h"

typedef struct condition {
  struct edge *preset;
  struct edge *postset;
  unsigned long id;
  unsigned long gen_idx;
  unsigned long pl_id;
} Condition;


typedef struct event {
  struct edge *preset;
  struct edge *postset;
  unsigned long id;
  unsigned long tr_id;
  unsigned long gen_idx;
  unsigned long corr_event_idx;
  unsigned long config_size;
  unsigned long foata_level;
  unsigned long *marking;
  BOOL prefix_cut_off;
  BOOL omega_prefix_cut_off;
  BOOL L_prefix_cut_off;
  BOOL success;
  BOOL can_stutter;
  unsigned long history_L_event;
  struct event *next_marking_event;
  EVENT_QUEUE_INFO *info;
} Event;


typedef struct edge {
  struct edge *nextcondition;
  struct edge *nextevent;
  struct condition *condition;
  struct event *event;
} Edge;



#define PREFIX_MINALLOC 4
#define PREFIX_MIN_LEVEL_ALLOC 4


class Prefix
{
public:

  Prefix(PTNet *net, BOOL do_ltl);
  ~Prefix();

  // Do not cache the values returned below over inserts!

  Condition **getConditions(void) {return conditions;};
  Event **getEvents(void) {return events;};

  unsigned long getNumConditions(void) {return num_conditions;};
  unsigned long getNumEvents(void) {return num_events;};
  unsigned long getNumEdges(void) {return num_edges;};

  unsigned long getNumAddedConditions(void) {return curr_condition_id; }
  unsigned long getNumAddedEvents(void) {return curr_event_id; }
  unsigned long getNumAddedCutOffs(void);
  
  unsigned long AddInitialCondition(unsigned long pl_id);
  unsigned long AddCondition(unsigned long pl_id);
  unsigned long AddEvent(unsigned long tr_id,
			 unsigned long preset_size,
			 unsigned long *preset,
			 unsigned long postset_size,
			 unsigned long *postset,
			 BOOL can_stutter);
  void AssignIDs(unsigned long event_idx);
  void SetMarking(unsigned long event_idx,
		  unsigned long *marking) { events[event_idx]->marking = marking; };
  BOOL CheckCutOff(unsigned long event_idx);

  unsigned long GetLocalConfigSize(unsigned long event_idx);
  unsigned long *GetParikh(unsigned long event_idx);
  unsigned long GetFoataLevel(unsigned long event_idx);
  unsigned long *GetFoata(unsigned long event_idx);
  unsigned long *GetMarking(unsigned long event_idx);
  unsigned long GetNumIEvents(unsigned long event_idx);
  unsigned long GetLEventIdx(unsigned long event_idx);
  BOOL IsBuchiEvent(unsigned long event_idx) { return (net->isBuchiTransition(events[event_idx]->tr_id)); };
  BOOL IsIEvent(unsigned long event_idx) { return (net->isAccepting(events[event_idx]->tr_id)); };
  BOOL IsLEvent(unsigned long event_idx) { return (net->isLTransition(events[event_idx]->tr_id)); };
  BOOL IsSuccess(unsigned long event_idx) {return (events[event_idx]->success); };
  BOOL InConflict(unsigned long event_idx1, unsigned long event_idx2);

  EVENT_QUEUE_INFO *GetEventInfo(unsigned long event_idx) { return (events[event_idx]->info); };
  void SetEventInfo(unsigned long event_idx,
		    EVENT_QUEUE_INFO *info) { events[event_idx]->info = info; };
  void SetEventQueue(EventQueue *in_event_queue) {event_queue = in_event_queue; };

  BOOL ExpandLPreset(unsigned long transition_idx, SARRAY *tr_preset);

  void PrintMarking(unsigned long *marking);

  BOOL WriteMciFile(FILE *out);

  void PrintCounterexample(void);

  void PrintLTLStats(void);
  
protected:

  Edge *newEdge(void);

  Condition **conditions;
  Event **events;
  Edge **edges;

  PTNet *net;

  unsigned long *event_index;
  unsigned long *condition_index;

  unsigned long num_conditions;
  unsigned long num_events;
  unsigned long num_edges;

  unsigned long num_alloc_conditions;
  unsigned long num_alloc_events;
  unsigned long num_alloc_edges;

  unsigned long curr_condition_id;
  unsigned long curr_event_id;

  BOOL do_ltl;

private:

  // Do some caching locally to speed up some
  // algorithms.

  void CacheLocalConfig(unsigned long event_idx);

  void WriteNum(unsigned long num, FILE *out);
  void WriteString(char *str, FILE *out);
  void InitIndexes(void);
  
  unsigned long cache_event;
  MONSET *cache_config;
  UL_STACK *cache_stack;
  MSET *cache_parikh;

  unsigned long num_foata_levels;
  unsigned long num_alloc_foata_levels;
  DARRAY **cache_foata_levels;

  MSET *initial_marking;
  DARRAY *initial_conditions;
  DYNPHASH *markings;

  EventQueue *event_queue;

  BOOL in_co_counterexample; // In co counterexamples need special handling

  unsigned long num_added_cutoffs;
				  
};

#endif /* PREFIX_H */
