// Copyright 1998,2000 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#ifndef DPHASH_H
#define DPHASH_H

#include "combi.h"
#include "ulhash.h"

#define DYNP_HASH_MINSIZE 16
#define DYNP_HASH_KEY unsigned long
#define DYNP_HASH_DATA void

typedef struct dynp_hash_table_item
{
  DYNP_HASH_KEY *key;              /* The hash key. */
  DYNP_HASH_DATA *data;            /* Actual data. */
  unsigned long signature;         /* Full hash signature to minimize key
				      comparisons. If comparisons are
				      cheap, make another hash routine
                                      where this signature is recalculated
                                      when needed. */
} DYNP_HASH_ITEM;

typedef struct dynp_hash_table
{
  unsigned long array_items;       /* The number of items allocated. */
  unsigned long mask;              /* The mask used. */
  unsigned long max_items;         /* The max number of items used by array. */
  unsigned long num_items;         /* The number of items used by array. */
  DYNP_HASH_ITEM *items;            /* Pointer to the hash array. */ 
} DYNPHASH;


DYNPHASH *CreateDynPHash(unsigned long initial_items);
void DeleteDynPHash(DYNPHASH *hash);
void ClearDynPHash(DYNPHASH *hash);
BOOL DynPInsertDataTellIfNew(DYNPHASH *hash,
			     DYNP_HASH_KEY *key,
			     DYNP_HASH_DATA *data);
DYNP_HASH_DATA *DynPInsertDataIfNew(DYNPHASH *hash,
				    DYNP_HASH_KEY *key,
				    DYNP_HASH_DATA *data);



// Internal implementation stuff

void ExpandDynPHash(DYNPHASH *hash);
void ExpandRehashDynPHash(DYNPHASH *hash);

#endif DPHASH_H
