/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* occ_net.c                 */
/* Burkhard Graves, 26.10.94 */
/*****************************/

#include <string.h>
#include "occ_net.h"
#include "mca.h"

/********************/
/* Globale Variable */
/********************/

char **pl_names; /* fuer ReadMciFile(), FreeAll() */
                 /* GetPlName(), GetPlNumname()   */
char **tr_names; /* fuer ReadMciFile(), FreeAll() */
                 /* GetTrName(), GetTrNumname()   */
char *names;     /* fuer ReadMciFile(), FreeAll() */
                 /* (extern)                      */

/**************************************************************************/
/* Erzeugung einer Kante.                                                 */
/**************************************************************************/

static Edge *create_edge(Condition *condition,Event *event,
                         Edge *nextcondition,Edge *nextevent)
{
    Edge *edge;

    edge=(Edge *)MyMalloc(sizeof(Edge));
    edge->condition=condition;
    edge->event=event;
    edge->nextcondition=nextcondition;
    edge->nextevent=nextevent;
    return edge;
}

/**************************************************************************/
/* Loeschen eines Netzes.                                                 */
/**************************************************************************/

static void sub_del(VCEvent *vce)
{
    if (vce) {
        sub_del(vce->next);
        SetDelete(vce->causes_corr_event);
        SetDelete(vce->causes_event);
        IListDelete(vce->ilist);
        MyFree(vce);
    }
}

void DeleteBraProcess(BraProcess *bprocess)
{
    register Edge    *edge,*edge_mem;
    register Event   *event;

    if (bprocess) {
        sub_del(bprocess->vcevents);
        event=++bprocess->events;
        while (event) {
            edge=event->preset;
            while (edge) {
                edge=(edge_mem=edge)->nextcondition;
                MyFree(edge_mem);
            }
            edge=event->postset;
            while (edge) {
                edge=(edge_mem=edge)->nextcondition;
                MyFree(edge_mem);
            }
            if (event->info) {
                SetDelete(event->info->causes_corr_event);
                SetDelete(event->info->causes_event);
                if (event->info->ilist)
                    IListDelete(event->info->ilist);
                MyFree(event->info);
            }
            event=event->next;
        }
        if (bprocess->events)
            MyFree(bprocess->events);
        if (bprocess->conditions)
            MyFree(++bprocess->conditions);
        MyFree(bprocess);
    }
}

/**************************************************************************/
/* Den numerischen Namen einer Stellenbeschriftung liefern.               */
/**************************************************************************/

unsigned GetPlNumname(char *ptr)
{
    char **calc_ptr;

    calc_ptr=pl_names;
    while (*calc_ptr) {
        if (!strcmp(*calc_ptr,ptr))
            return ((unsigned)(calc_ptr-pl_names))+1;
        ++calc_ptr;
    }
    return 0;
}

/**************************************************************************/
/* Die Stellenbeschriftung zu einem numerischen Namen liefern.            */
/**************************************************************************/

char *GetPlName(unsigned numname)
{
    return *(pl_names+numname-1);
}

/**************************************************************************/
/* Den numerischen Namen einer Transitionsbeschriftung liefern.           */
/**************************************************************************/

unsigned GetTrNumname(char *ptr)
{
    char **calc_ptr;

    calc_ptr=tr_names;
    while (*calc_ptr) {
        if (!strcmp(*calc_ptr,ptr))
            return ((unsigned)(calc_ptr-tr_names))+1;
        ++calc_ptr;
    }
    return 0;
}

/**************************************************************************/
/* Die Transitionsbeschriftung zu einem numerischen Namen liefern.        */
/**************************************************************************/

char *GetTrName(unsigned numname)
{
    return *(tr_names+numname-1);
}

/**************************************************************************/
/* Einlesen einer mci-Datei.                                              */
/**************************************************************************/

#define READNUM(NUMBER) fread((void *)&(NUMBER),sizeof(unsigned),1,in);

void ReadMciFile(FILE *in)
{
    Condition  *condition;
    Event      *event;
    Set        *set;
    char       *ptr;
    char       **calc_ptr;
    unsigned    i,num;

    bprocess=(BraProcess *)MyMalloc(sizeof(BraProcess));
    bprocess->vcevents=NULL;
    bprocess->num_vce=0;
    READNUM(bprocess->num_conditions);
    READNUM(bprocess->num_events);
    bprocess->conditions
    =(Condition *)MyMalloc(sizeof(Condition)*bprocess->num_conditions);
    if (bprocess->num_events) {
        bprocess->events
        =(Event *)MyMalloc(sizeof(Event)*bprocess->num_events);
        event=bprocess->events;
        for (i=1; i<=bprocess->num_events; ++i) {
            event->numname=i;
            READNUM(event->tr_numname);
            event->preset=event->postset=NULL;
            event->info=NULL;
            event=event->next=event+1;
        }
        (--event)->next=NULL;
        event=bprocess->events-1;
    } else
        event=bprocess->events=NULL;
    condition=bprocess->conditions;
    for (i=1; i<=bprocess->num_conditions; ++i) {
        condition->numname=i;
        READNUM(condition->pl_numname);
        condition->preset=condition->postset=NULL;
        READNUM(num);
        if (num)
            (event+num)->postset=condition->preset
            =create_edge(condition,event+num,
                         (event+num)->postset,condition->preset);
        READNUM(num);
        while(num) {
            (event+num)->preset=condition->postset
            =create_edge(condition,event+num,
                         (event+num)->preset,condition->postset);
            READNUM(num);
        }
        condition=condition->next=condition+1;
    }
    (--condition)->next=NULL;
    --bprocess->conditions;  /* Damit spaeter z.B. ((bprocess->events)+1)  */
    --bprocess->events;      /* auf das erste Ereignis in der Liste zeigt. */
    initial_marking=LCond(min=Min(bprocess));
    cutoffs=SetCreate();
    READNUM(num);
    while (num) {
        SetInsertElement(cutoffs,num);
        i=num; READNUM(num);
        ((bprocess->events+i)->info=(Info *)MyMalloc(sizeof(Info)))
        ->corr_event=num;
        READNUM(num);
    }
    i=0;
    max_configs=SListCreate(set=SetCreate());
    READNUM(num);
    while (num) {
        ++i;
        if (!set)
            SListNoTestInsert(max_configs,set=SetCreate());
        while (num) {
            SetInsertElement(set,num);
            READNUM(num);
        }
        set=NULL;
        READNUM(num);
    }
    anz_max_configs=i;
    READNUM(num); /* # Places */
    pl_names=(char **)MyMalloc(sizeof(char *)*(num+1));
    i=num;
    READNUM(num); /* # Transitions */
    tr_names=(char **)MyMalloc(sizeof(char *)*(num+1));
    i+=num;
    READNUM(num); /* max. Laenge eines Namens */
    names=(char *)MyMalloc(num=(num+1)*i+2);
    names=(char *)MyRealloc(names,fread((void *)names,1,num,in));
    calc_ptr=pl_names;
    ptr=names;
    while (*ptr) {
        *calc_ptr=ptr;
        ++calc_ptr;
        while (*++ptr)
            ;
        ++ptr;
    }
    *calc_ptr=NULL;
    calc_ptr=tr_names;
    ++ptr;
    while (*ptr) {
        *calc_ptr=ptr;
        ++calc_ptr;
        while (*++ptr)
            ;
        ++ptr;
    }
    *calc_ptr=NULL;
}

/*************************/
/* END OF FILE occ_net.c */
/*************************/
