/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* tree.c                    */
/* Burkhard Graves, 26.10.94 */
/*****************************/

#include "tree.h"
#include "occ_net.h"
#include "y_tab.h"

/**************************************************************************/
/* Erzeugung eines Syntaxbaum-Knotens.                                    */
/**************************************************************************/

TreeNode *TreeCreateNode(int info,TreeNode *left,TreeNode *right)
{
    TreeNode *node;

    (node=(TreeNode *)MyMalloc(sizeof(TreeNode)))->info=info;
    node->left=left;
    node->right=right;
    return node;
}

/**************************************************************************/
/* Duplizieren des Syntaxbaumes.                                          */
/**************************************************************************/

TreeNode *TreeCopy(TreeNode *node)
{
    if (node)
        return TreeCreateNode(node->info,
                              (node->info!=PLACE)?
                              TreeCopy(node->left) : node->left,
                              TreeCopy(node->right));
    else
        return NULL;
}

/**************************************************************************/
/* Loeschen des Syntaxbaumes.                                             */
/**************************************************************************/

void TreeDelete(TreeNode *node)
{
    if (node) {
        if (node->info!=PLACE) {
            TreeDelete(node->left);
            TreeDelete(node->right);
        }
        MyFree(node);
    }
}

/**************************************************************************/
/* Ausgabe des Syntaxbaumes.                                              */
/**************************************************************************/

void TreeDisplay(FILE *out,TreeNode *node)
{
    char *ptr=NULL;

    if (node) {
        switch (node->info) {
        case PLACE:
            fprintf(out,GetPlName((unsigned)(node->left)));
            break;
        case FALSE:
            fprintf(out,"false");
            break;
        case TRUE:
            fprintf(out,"true");
            break;
        default:
            fputc('(',out);
            TreeDisplay(out,node->left);
            switch (node->info) {
            case EXISTS:    ptr="E ";       break;
            case DIAMOND:   ptr="D ";       break;
            case OR:        ptr=" or ";     break;
            case AND:       ptr=" and ";    break;
            case NOT:       ptr="not ";     break;
            default:
                Fatal("TreeDisplay(): default ?");
                break;
            }
            fprintf(out,ptr);
            TreeDisplay(out,node->right);
            fputc(')',out);
        }
    }
}

/**************************************************************************/
/* Auffinden von Disjunktionsgliedern.                                    */
/**************************************************************************/

TreeNode *DeliverSubformula(TreeNode *node)
{
    TreeNode *ptr,*mem;

    if (node->info==OR) {
        if ((ptr=DeliverSubformula(node->left))==node->left) {
            *node=*(mem=node->right);
            MyFree(mem);
        } else if (!ptr && (ptr=DeliverSubformula(node->right))==node->right) {
            *node=*(mem=node->left);
            MyFree(mem);
        }
        return ptr;
    }
    return node;
}

/**************************************************************************/
/* Auffinden von Diamonds in einem Disjunktionsglied.                     */
/**************************************************************************/

TreeNode *DeliverDiamond(TreeNode *node)
{
    TreeNode *ptr,*mem;

    if (node->info==AND) {
        if ((ptr=DeliverDiamond(node->left))==node->left) {
            *node=*(mem=node->right);
            MyFree(mem);
        } else if (!ptr && (ptr=DeliverDiamond(node->right))==node->right) {
            *node=*(mem=node->left);
            MyFree(mem);
        }
        return ptr;
    } else if (node->info==DIAMOND
               || (node->info==NOT && node->right->info==DIAMOND)) {
        return node;
    }
    return NULL;
}

/**************************************************************************/
/* Auffinden von Diamonds oder Quantoren in einem Disjunktionsglied.      */
/**************************************************************************/

TreeNode *DeliverDiamOrQuan(TreeNode *node)
{
    TreeNode *ptr,*mem;

    if (node->info==AND) {
        if ((ptr=DeliverDiamOrQuan(node->left))==node->left) {
            *node=*(mem=node->right);
            MyFree(mem);
        } else if (!ptr && (ptr=DeliverDiamOrQuan(node->right))==node->right) {
            *node=*(mem=node->left);
            MyFree(mem);
        }
        return ptr;
    } else if (node->info==DIAMOND
               || node->info==EXISTS
               || (node->info==NOT && (node->right->info==DIAMOND
                                       || node->right->info==EXISTS))) {
        return node;
    }
    return NULL;
}

/**********************/
/* END OF FILE tree.c */
/**********************/
