// Copyright 1998 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#include "combi.h"

#define UL_STACK_PAGE_ELEMENTS 1024    /* This must be a power of two! */

typedef unsigned long UL_STACK_ELEMENT;

typedef struct ul_stack_page
{
  UL_STACK_ELEMENT *first_item;    /* The stack data is stored here. */
  UL_STACK_ELEMENT *last_item;     /* The last item. */
  struct ul_stack_page *prev;      /* The page before this, NULL if none. */
} UL_STACK_PAGE;

typedef struct ul_stack
{
  UL_STACK_ELEMENT *curr_item;     /* The current stack pointer. */
  UL_STACK_ELEMENT *first_item;    /* The first item of current page. */
  UL_STACK_ELEMENT *last_item;     /* The last item of current page. */
  UL_STACK_PAGE *last_page;        /* The current page. */
  unsigned long num_pages;         /* The page count. */
} UL_STACK;

#define ULStackLastItem(first_item) \
(&(first_item)[UL_STACK_PAGE_ELEMENTS])

#define ULStackEmpty(stack) \
((((stack)->curr_item == (stack)->first_item) && \
  ((stack)->num_pages == 1)) ? TRUE : FALSE)


#define PushULStack(stack, i1) \
{ \
    if((stack)->curr_item >= (stack)->last_item) { \
      GrowULStack(stack); \
    } \
    (stack)->curr_item[0] = (UL_STACK_ELEMENT)(i1); \
    (stack)->curr_item = &((stack)->curr_item[1]); \
}

/* Do NOT call the PeekULStack() macro when the stack is empty! */

#define PeekULStack(stack, i1) \
i1 = (stack)->curr_item[-1];

/* Do NOT call the PopULStack() macro when the stack is empty! */

#define PopULStack(stack, i1) \
i1 = (stack)->curr_item[-1]; \
stack->curr_item = &((stack)->curr_item[-1]); \
if((stack)->curr_item <= (stack)->first_item && \
   (stack->num_pages != 1)) { \
  ShrinkULStack(stack); \
}

UL_STACK *CreateULStack(void);

void DeleteULStack(UL_STACK *stack);

void GrowULStack(UL_STACK *stack);

void ShrinkULStack(UL_STACK *stack);
