/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* set.h                     */
/* Burkhard Graves, 26.10.94 */
/*****************************/

#ifndef __SET_H__
#define __SET_H__

#include "main.h"

/*******************/
/* Typdefinitionen */
/*******************/

/*-------*/
/* Menge */
/*-------*/

typedef struct set {
    unsigned max_sector;    /* Anzahl der Sektoren - 1  */
    unsigned *sector;       /* Zeiger auf ersten Sektor */
} Set;

/**************/
/* Prototypen */
/**************/

void             InitMaske PROTO ((void));
Set          *SetDuplicate PROTO ((Set *set));
Set               *SetCopy PROTO ((Set *set1,Set *set2));
Set               *SetSwap PROTO ((Set *set1,Set *set2));
Set             *SetCreate PROTO ((void));
void             SetDelete PROTO ((Set *set));
Set              *SetClear PROTO ((Set *set));
int       SetInsertElement PROTO ((Set *set,unsigned element));
int       SetRemoveElement PROTO ((Set *set,unsigned element));
unsigned SetGetElementNext PROTO ((Set *set,unsigned element));
unsigned SetGetElementPrev PROTO ((Set *set,unsigned element));
int           SetIsElement PROTO ((Set *set,unsigned element));
int             SetIsEmpty PROTO ((Set *set));
unsigned  SetCountElements PROTO ((Set *set));
int            SetIsSubset PROTO ((Set *set1, Set *set2));
int             SetIsEqual PROTO ((Set *set1, Set *set2));
int            SetDisjunct PROTO ((Set *set1, Set *set2));
Set              *SetUnion PROTO ((Set *set1, Set *set2));
unsigned   SetFirstOfInter PROTO ((Set *set1, Set *set2));
Set       *SetIntersection PROTO ((Set *set1, Set *set2));
Set *SetIntersectionCreate PROTO ((Set *set1, Set *set2));
Set         *SetDifference PROTO ((Set *set1, Set *set2));
Set                *SetEOR PROTO ((Set *set1, Set *set2));
void            SetDisplay PROTO ((FILE *out,Set *set));
Set               *SetRead PROTO ((FILE *in));
void               SetSave PROTO ((FILE *out,Set *set));

#endif

/*********************/
/* END OF FILE set.h */
/*********************/
