/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* list.h                    */
/* Burkhard Graves, 26.10.94 */
/*****************************/

#ifndef __LIST_H__
#define __LIST_H__

#include "main.h"
#include "set.h"

/*******************/
/* Typdefinitionen */
/*******************/

/*----------------------------*/
/* Liste von Mengen (SetList) */
/*----------------------------*/

typedef struct slist {
    Set          *set;      /* Zeiger auf Menge         */
    struct slist *next;     /* naechstes Listenelement  */
} SList;

/*------------------------------*/
/* Liste fuer den Isomorphismus */
/*------------------------------*/

typedef struct ilist {
    unsigned      x;        /* x                        */
    unsigned      y;        /* f(x)                     */
    struct ilist *next;     /* naechstes Listenelement  */
} IList;

/**************/
/* Prototypen */
/**************/

SList        *SListCreate PROTO ((Set *set));
void          SListDelete PROTO ((SList *slist));
SList *SListHeadDuplicate PROTO ((SList *slist));
void         SListDisplay PROTO ((FILE *out,SList *slist));
void    SListNoTestInsert PROTO ((SList *slist,Set *set));
int    SListInsertElement PROTO ((SList *slist,Set *set));
int        SListMaxInsert PROTO ((SList *slist,Set *set));
int        SListMinInsert PROTO ((SList *slist,Set *set));

IList      *IListCreate PROTO ((unsigned x, unsigned y));
void        IListDelete PROTO ((IList *ilist));
void IListInsertElement PROTO ((IList *ilist,unsigned x,unsigned y));
void       IListDisplay PROTO ((FILE *out,IList *ilist));

#endif

/**********************/
/* END OF FILE list.h */
/**********************/
