// Copyright 1998,1999 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

////////////////////////////////////////////////////////////////////////
//
// Thanks to Burkhard for permission to use his code.
//
// This YACC code is based on the following YACC file:
// (See subdirectory mci)
//
////////////////////////////////////////////////////////////////////////

/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* mc.y                      */
/* Burkhard Graves, 26.10.94 */
/*****************************/

%{
#include "scanner.h"
#include "tree.h"

TreeNode * result_tree;
%}

%union {
        TreeNode    *node;
        unsigned    wert;
}

%token  FORALL
%token  EXISTS
%token  BOX
%token  DIAMOND
%token  IMPL
%token  GDW
%token  OR
%token  AND
%token  NOT
%token  FALSE_TOKEN
%token  TRUE_TOKEN
%token  <wert> PLACE

/* Vorrang und Assoziativitaet der Operatoren */

%left       GDW
%left       IMPL
%left       OR
%left       AND
%nonassoc   FORALL EXISTS BOX DIAMOND
%nonassoc   NOT
%nonassoc   FALSE_TOKEN TRUE_TOKEN PLACE

%type <node> formula form

%%

formula : form                  { $$=$1; result_tree = $$;}

form    : '(' form ')'          { $$=$2; }
        | '[' form ']'          { $$=$2; }
        | '{' form '}'          { $$=$2; }
        | BOX form
            {
                $$=TreeCreateNode(NOT,
                                  NULL,
                                  TreeCreateNode(DIAMOND,
                                                 NULL,
                                                 TreeCreateNode(NOT,
                                                                NULL,
                                                                $2)));
            }
        | DIAMOND form          { $$=TreeCreateNode(DIAMOND,NULL,$2); }
        | form IMPL form
            {
                $$=TreeCreateNode(OR,TreeCreateNode(NOT,NULL,$1),$3);
            }
        | form GDW form
            {
                $$=TreeCreateNode(OR,
                                  TreeCreateNode(AND,
                                                 TreeCopy($1),
                                                 TreeCopy($3)),
                                  TreeCreateNode(AND,
                                                 TreeCreateNode(NOT,
                                                                NULL,
                                                                $1),
                                                 TreeCreateNode(NOT,
                                                                NULL,
                                                                $3)));
            }
        | form OR form          { $$=TreeCreateNode(   OR,  $1,  $3); }
        | form AND form         { $$=TreeCreateNode(  AND,  $1,  $3); }
        | NOT form              { $$=TreeCreateNode(  NOT,NULL,  $2); }
        | FALSE_TOKEN           { $$=TreeCreateNode(FALSE_TOKEN,NULL,NULL); }
        | TRUE_TOKEN            { $$=TreeCreateNode(TRUE_TOKEN,NULL,NULL); }
        | PLACE                 { $$=TreeCreateNode(PLACE,NULL,NULL,$1); }

%%

int yyerror(const char *ptr)
{
    fprintf(stderr,"\nPARSING-ERROR (%s)!!!\n\n",ptr);
    return 0;
}


TreeNode * ParseFormula(void)
{

  result_tree = (TreeNode *) NULL;

  if(yyparse() != 0) {
    result_tree = (TreeNode *) NULL;
  }

  return result_tree;

}


/********************/
/* END OF FILE mc.y */
/********************/
