// Copyright 1998 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

////////////////////////////////////////////////////////////////////////
// This C++ code is based on the following C file: (See subdirectory mci)
//
// Thanks to Burkhard for permission to use his code.
//
////////////////////////////////////////////////////////////////////////

/*****************************/
/* occ_net.h                 */
/* Burkhard Graves, 26.10.94 */
/*****************************/
                            
/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

////////////////////////////////////////////////////////////////////////

#ifndef BRAPROCESS_H
#define BRAPROCESS_H

#include <stdio.h>
#include "combi.h"
#include "bitarr.h"

////////////////////////////////////////////////////////////////////////
//
// The following structs are from PEP, with modifications.
//
// See file mci/occ_net.h for original source code.
//
////////////////////////////////////////////////////////////////////////

/*---------------------------------------------*/
/* Zusatz-Informationen fuer die Cutoff-Events */
/*---------------------------------------------*/

typedef struct Info_ {
    unsigned long  corr_event;         /* korrespondierendes Event         */
//    Set * causes_corr_event;         /* Geschichte des korresp. Events   */
//    Set * causes_event;              /* Geschichte des Cutoff-Events     */
//    IList * ilist;                   /* Zeiger auf Isomorphismus         */
} Info;

/*--------------------*/
/* Bedingung (Stelle) */
/*--------------------*/

typedef struct Cond_ {
    struct Cond_ * next;           /* Zeiger auf naechste Bedingung           */
    struct Edge_ * preset;         /* Zeiger auf erste Kante des Vorbereichs  */
    struct Edge_ * postset;        /*   bzw. des Nachbereichs                 */
    unsigned long numname;         /* Numerischer Name                        */
    unsigned long pl_numname;      /* Numerischer Name der entspr. Stelle     */
} Condition;

/*-----------------------*/
/* Ereignis (Transition) */
/*-----------------------*/

typedef struct Evnt_ {
    struct Evnt_ * next;       /* Zeiger auf naechstes Ereignis           */
    struct Edge_ * preset;     /* Zeiger auf erste Kante des Vorbereichs  */
    struct Edge_ * postset;    /*   bzw. des Nachbereichs                 */
    Info * info;               /* Informationen, falls Cutoff-Event       */
    unsigned long numname;     /* Numerischer Name                        */
    unsigned long tr_numname;  /* Numerischer Name der entspr. Transition */
} Event;

/*-------*/
/* Kante */
/*-------*/

typedef struct Edge_ {
    struct Edge_ * nextcondition;    /* vertikale Verkettung     */
    struct Edge_ * nextevent;        /* horizontale Verkettung   */
    Condition * condition;           /* Zeiger auf Bedingung     */
    Event * event;                   /* Zeiger auf Ereignis      */
} Edge;

////////////////////////////////////////////////////////////////////////
//
// End of PEP stuff.
//
////////////////////////////////////////////////////////////////////////


class BraProcess
{
public:
  
  BraProcess ();
  ~BraProcess ();

  BOOL IsCutoff (unsigned long event_num);
  BOOL IsCutoffPostset (unsigned long condition_num);
  BOOL ConditionHasRealConflict(unsigned long condition_num);
  BOOL EventHasRealConflict(unsigned long event_num);
  BOOL ConditionHasEmptyRealPostset(unsigned long condition_num);
  BOOL EventHasSingletonPrepreset(unsigned long event_num);
  BOOL IsTranslationEvent(unsigned long event_num);
  BOOL IsTranslationCondition(unsigned long condition_num);
  BOOL IsInInitialState(unsigned long place_num);
  BOOL IsInAnyState(unsigned long place_num);
  
  void AddPresetEvents(BITARRAY * current_configuration);
  unsigned long ContinueToDeadlock(BITARRAY * current_configuration);
  void InitVisibility(BITARRAY * needed_conditions,
		      BITARRAY * visible_events);
  void InitTranslation(BITARRAY * visible_events);
  unsigned long GiveAnyPreEvent(unsigned long place_num);
  
  // Start of PEP stuff.
  
  int ReadMciFile(FILE * in);
  unsigned long GetPlNumname(char *ptr);
  char * GetPlName(unsigned long numname);

  Condition * conditions;
  Event * events;
  unsigned long num_conditions;
  unsigned long num_events;

  char **pl_names;
  char **tr_names;
  char *names;

  // End of PEP stuff.

  unsigned long num_edges;
  unsigned long num_cutoffs;
  
  BITARRAY * cutoffs;
  BITARRAY * min_elements;

  BITARRAY * real_conflict_conditions;
  BITARRAY * real_conflict_events;
  BITARRAY * empty_real_postset_conditions;
  BITARRAY * singleton_prepreset_events;
  BITARRAY * translation_events;
  BITARRAY * translation_conditions;
  
private:

  void InitInfo();
  void InitMin();
  Edge * create_edge(Condition * condition,
		     Event * event,
		     Edge * nextcondition,
		     Edge * nextevent);
  
};


inline BOOL BraProcess::IsCutoff (unsigned long event_num)
{

  if(GetBit(cutoffs, (event_num - 1))) {
    return TRUE;
  } else {
    return FALSE;
  }

}


inline BOOL BraProcess::ConditionHasRealConflict(unsigned long condition_num)
{

  if(GetBit(real_conflict_conditions, (condition_num -1))) {
    return TRUE;
  } else {
    return FALSE;
  }

}

inline BOOL BraProcess::EventHasRealConflict(unsigned long event_num)
{

  if(GetBit(real_conflict_events, (event_num -1))) {
    return TRUE;
  } else {
    return FALSE;
  }

}

inline BOOL BraProcess::ConditionHasEmptyRealPostset(unsigned long condition_num)
{

  if(GetBit(empty_real_postset_conditions, (condition_num -1))) {
    return TRUE;
  } else {
    return FALSE;
  }

}

inline BOOL BraProcess::EventHasSingletonPrepreset(unsigned long event_num)
{

  if(GetBit(singleton_prepreset_events, (event_num -1))) {
    return TRUE;
  } else {
    return FALSE;
  }

}

inline BOOL BraProcess::IsTranslationEvent(unsigned long event_num)
{

  if(GetBit(translation_events, (event_num -1))) {
    return TRUE;
  } else {
    return FALSE;
  }

}

inline BOOL BraProcess::IsTranslationCondition(unsigned long condition_num)
{

  if(GetBit(translation_conditions, (condition_num -1))) {
    return TRUE;
  } else {
    return FALSE;
  }

}


#endif BRAPROCESS_H
