/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* scanner.c                 */
/* Burkhard Graves, 26.10.94 */
/*****************************/

#include <ctype.h>
#include <string.h>
#include "scanner.h"
#include "occ_net.h"
#include "tree.h"
#include "y_tab.h"

#define get(arg) (arg=getc(yyin))
#define unget(arg) (ungetc(arg,yyin))

/**************************************************************************/
/* Offensichtlich                                                         */
/**************************************************************************/

static int follow(int expect,int ifyes,int ifno)
{
    int c;

    if ((get(c))==expect)
        return ifyes;
    unget(c);
    return ifno;
}

/**************************************************************************/
/* Der Scanner                                                            */
/**************************************************************************/

int yylex(void)
{
    #define YYTEXT_SIZE 80

    char *ptr,yytext[YYTEXT_SIZE];
    int i,c;

    for (;;) {
        get(c);
        if (isspace(c))
            continue;
        if (c=='_' || isalpha(c)) {     /* Bezeichner */
            ptr=yytext; i=0;
            do {
                *ptr++=c;
                get(c);
            } while (++i<YYTEXT_SIZE && (c=='_' || isalnum(c)));
            unget(c);
            *ptr='\0';
            if ((yylval.wert=GetPlNumname(ptr-=i))==0)
                Fatal("Scanner(): Stellenname unbekannt !");
            return PLACE;
        } else {
            switch (c) {
            case 179:
            case '!': return FORALL;
            case 180:
            case '?': return EXISTS;
            case 174:
            case '-': return NOT;
            case 172:
            case '*': return AND;
            case 199:
            case '+': return OR;
            case '1': return TRUE;
            case '0': return FALSE;
            case 183:
            case '^': return DIAMOND;
            case 182:
            case '#': return BOX;
            case 176: return IMPL;
            case '=': return follow('>',IMPL,1);
            case 175: return GDW;
            case '<':
                if (get(i)=='=' && get(i)=='>')
                    return GDW;
                else
                    return 1;
            case '%':
                while (get(c)!='\n')
                    if (c==EOF)
                        return 0;
                break;
            case '.': return 0;
            case EOF: return 0;
            default:  return c;
            }
        }
    }
}

/*************************/
/* END OF FILE scanner.c */
/*************************/
