/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* mc.y                      */
/* Burkhard Graves, 26.10.94 */
/*****************************/

%{
#include "scanner.h"
#include "tree.h"
%}

%union {
        TreeNode    *node;
        unsigned    wert;
}

%token  FORALL
%token  EXISTS
%token  BOX
%token  DIAMOND
%token  IMPL
%token  GDW
%token  OR
%token  AND
%token  NOT
%token  FALSE
%token  TRUE
%token  <wert> PLACE

/* Vorrang und Assoziativitaet der Operatoren */

%left       GDW
%left       IMPL
%left       OR
%left       AND
%nonassoc   FORALL EXISTS BOX DIAMOND
%nonassoc   NOT
%nonassoc   FALSE TRUE PLACE

%type <node> formel form

%%

formel  : '(' formel ')'        { $$=$2; }
        | '[' formel ']'        { $$=$2; }
        | '{' formel '}'        { $$=$2; }
        | FORALL form
            {
                $$=TreeCreateNode(NOT,
                                  NULL,
                                  TreeCreateNode(EXISTS,
                                                 NULL,
                                                 TreeCreateNode(NOT,
                                                                NULL,
                                                                $2)));
            }
        | EXISTS form           { $$=TreeCreateNode(EXISTS,NULL,$2); }
        | BOX form
            {
                $$=TreeCreateNode(NOT,
                                  NULL,
                                  TreeCreateNode(DIAMOND,
                                                 NULL,
                                                 TreeCreateNode(NOT,
                                                                NULL,
                                                                $2)));
            }
        | DIAMOND form          { $$=TreeCreateNode(DIAMOND,NULL,$2); }
        | formel IMPL formel
            {
                $$=TreeCreateNode(OR,TreeCreateNode(NOT,NULL,$1),$3);
            }
        | formel GDW formel
            {
                $$=TreeCreateNode(OR,
                                  TreeCreateNode(AND,
                                                 TreeCopy($1),
                                                 TreeCopy($3)),
                                  TreeCreateNode(AND,
                                                 TreeCreateNode(NOT,
                                                                NULL,
                                                                $1),
                                                 TreeCreateNode(NOT,
                                                                NULL,
                                                                $3)));
            }
        | formel OR formel      { $$=TreeCreateNode(   OR,  $1,  $3); }
        | formel AND formel     { $$=TreeCreateNode(  AND,  $1,  $3); }
        | NOT formel            { $$=TreeCreateNode(  NOT,NULL,  $2); }
        | FALSE                 { $$=TreeCreateNode(FALSE,NULL,NULL); }
        | TRUE                  { $$=TreeCreateNode( TRUE,NULL,NULL); }
        | PLACE       { $$=TreeCreateNode(PLACE,(TreeNode *)$1,NULL); }

form    : '(' form ')'          { $$=$2; }
        | '[' form ']'          { $$=$2; }
        | '{' form '}'          { $$=$2; }
        | BOX form
            {
                $$=TreeCreateNode(NOT,
                                  NULL,
                                  TreeCreateNode(DIAMOND,
                                                 NULL,
                                                 TreeCreateNode(NOT,
                                                                NULL,
                                                                $2)));
            }
        | DIAMOND form          { $$=TreeCreateNode(DIAMOND,NULL,$2); }
        | form IMPL form
            {
                $$=TreeCreateNode(OR,TreeCreateNode(NOT,NULL,$1),$3);
            }
        | form GDW form
            {
                $$=TreeCreateNode(OR,
                                  TreeCreateNode(AND,
                                                 TreeCopy($1),
                                                 TreeCopy($3)),
                                  TreeCreateNode(AND,
                                                 TreeCreateNode(NOT,
                                                                NULL,
                                                                $1),
                                                 TreeCreateNode(NOT,
                                                                NULL,
                                                                $3)));
            }
        | form OR form          { $$=TreeCreateNode(   OR,  $1,  $3); }
        | form AND form         { $$=TreeCreateNode(  AND,  $1,  $3); }
        | NOT form              { $$=TreeCreateNode(  NOT,NULL,  $2); }
        | FALSE                 { $$=TreeCreateNode(FALSE,NULL,NULL); }
        | TRUE                  { $$=TreeCreateNode( TRUE,NULL,NULL); }
        | PLACE       { $$=TreeCreateNode(PLACE,(TreeNode *)$1,NULL); }

%%

int yyerror(const char *ptr)
{
    fprintf(stderr,"\nPARSING-ERROR (%s)!!!\n\n",ptr);
    return 0;
}

/********************/
/* END OF FILE mc.y */
/********************/
