// Copyright 1998,1999 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

////////////////////////////////////////////////////////////////////////
//
// Thanks to Burkhard for permission to use his code.
//
// This C++ code is based on the following C file:
// (See subdirectory mci)
//
////////////////////////////////////////////////////////////////////////

/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* tree.h                    */
/* Burkhard Graves, 26.10.94 */
/*****************************/

#ifndef __TREE_H__
#define __TREE_H__

#include <stdio.h>
#include "atomrule.h"

/*******************/
/* Typdefinitionen */
/*******************/

/*------------------------*/
/* Knoten des Syntaxbaums */
/*------------------------*/

typedef struct treenode {
  int info;                   /* Art des Knotens  */
  struct treenode *left;      /* linker Sohn      */
  struct treenode *right;     /* rechter Sohn     */
  unsigned long place_num;
  Atom * place_atom;

} TreeNode;

/**************/
/* Prototypen */
/**************/

TreeNode* TreeCreateNode(int info,TreeNode *left,TreeNode *right,
			 unsigned long place_num = 0L,
			 Atom * place_atom = (Atom *)NULL);
TreeNode* TreeCopy(TreeNode *node);
void TreeDelete(TreeNode *node);
void TreeDisplay(FILE *out,TreeNode *node);

#endif

/**********************/
/* END OF FILE tree.h */
/**********************/
