/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* mca.h                     */
/* Burkhard Graves, 26.10.94 */
/*****************************/

#ifndef __MCA_H__
#define __MCA_H__

#include "main.h"
#include "list.h"
#include "set.h"
#include "tree.h"
#include "occ_net.h"

/****************************/
/* Externe globale Variable */
/****************************/

extern   TreeNode *tree;
extern BraProcess *bprocess;
extern        Set *cutoffs;
extern        Set *min;
extern        Set *initial_marking;
extern      SList *max_configs;
extern   unsigned anz_max_configs;
extern   unsigned multi;

/**************/
/* Prototypen */
/**************/

void                    Ask PROTO ((void));
void   DisplayMaxTrSequence PROTO ((FILE *out,SList *slist));
void     DisplayEventLabels PROTO ((FILE *out,Set *events));
void DisplayConditionLabels PROTO ((FILE *out,Set *conditions));
void      DisplayPlaceNames PROTO ((FILE *out,Set *places));
void            DisplayMark PROTO ((FILE *out,Set *mark));
SList          *MaxTriangle PROTO ((SList *slist1,SList *slist2));
SList             *MaxUnion PROTO ((SList *slist1,SList *slist2));
int              LowerEqual PROTO ((Set *configuration,SList *slist));
Set                    *Min PROTO ((BraProcess *bprocess));
void               CutInSet PROTO ((Set *cut,Set *configuration));
Set                    *Cut PROTO ((Set *configuration));
void             LCondInSet PROTO ((Set *labels,Set *conditions));
Set                  *LCond PROTO ((Set *conditions));
Set              *MarkInSet PROTO ((Set *mark,Set *configuration));
Set                   *Mark PROTO ((Set *configuration));
void            CausesInSet PROTO ((Set *causes,unsigned event));
Set                 *Causes PROTO ((unsigned event));
Set            *LocalCauses PROTO ((Set *lcut,unsigned event));
unsigned    GetCorrespEvent PROTO ((unsigned event));
void               ReadInfo PROTO ((FILE *in));
void               SaveInfo PROTO ((FILE *out));
void               CalcInfo PROTO ((void));
int               InPostCut PROTO ((Set *cut,unsigned event));
Set               *LocalCut PROTO ((Set *cut,Set *l_cut));
void                FreeAll PROTO ((void));
int       NoModalitiesAreOk PROTO ((TreeNode *tree));
int            ModelChecker PROTO ((void));

#endif

/*********************/
/* END OF FILE mca.h */
/*********************/
