// Copyright 1998 by Patrik Simons
// This software is provided as is, no warranty of any kind is given.
#ifndef TREE_H
#define TREE_H

class Atom;

class Tree
{
public:
  Tree ();
  ~Tree ();

  Atom *find (const char *);
  void insert (Atom *);
  void remove (Atom *);

  void check_consistency ();

private:
  class Node
  {
  public:
    Node (Atom *k = 0, Node *l = 0, Node *r = 0);
    ~Node ();
    
    Atom *key;
    Node *left;
    Node *right;
  };

  Node *root;

  Node *splay (const char *, Node *);

  void check_consistency (Node *);
  void flush (Node *);

  int compare (const char *, Atom *);
};

#endif
