// Copyright 1997 Patrik Simons
// This software is provided as is, no warranty of any kind is given.
//
// File:   timer.cc
// Author: Patrik Simons
//
#include <strstream.h>
#include <iomanip.h>
#include <limits.h>
#include "timer.h"

#define NO_PROCESS_TIME 0
#ifndef CLOCKS_PER_SEC
#ifndef CLK_TCK
#undef NO_PROCESS_TIME
#define NO_PROCESS_TIME 1
#define CLOCKS_PER_SEC 1
#else
#define CLOCKS_PER_SEC CLK_TCK
#endif
#endif

Timer::Timer ()
{
  sec = 0;
  msec = 0;
  calendar_sec = 0;
}

void
Timer::start ()
{
  timer = clock ();
  calendar_timer = time (0);
}

void
Timer::stop ()
{
  clock_t ticks = clock () - timer;
  calendar_sec += time (0) - calendar_timer;
  sec += ticks / CLOCKS_PER_SEC;
  msec += (ticks - sec*CLOCKS_PER_SEC)*1000/CLOCKS_PER_SEC;
  if (msec >= 1000)
    {
      msec -= 1000;
      sec++;
    }
}

void 
Timer::reset ()
{
  sec = 0;
  msec = 0;
  calendar_sec = 0;
}

char *
Timer::print ()
{
  static char s[20];
  ostrstream str (s, sizeof (s));
  if (calendar_sec >= LONG_MAX / CLOCKS_PER_SEC || NO_PROCESS_TIME)
    str << "Calendar " << (unsigned long)calendar_sec << ends;
  else
    str << sec << '.' << setw(3) << setfill('0') << msec << ends;
  return str.str ();
}
