// Copyright 1997 Patrik Simons
// This software is provided as is, no warranty of any kind is given.
//
// File:   stack.h
// Author: Patrik Simons
//
#ifndef STACK_H
#define STACK_H

#include <assert.h>

class Atom;

class Stack
{
public:
  Stack (long size = 0);
  ~Stack ();
  void Init (long size);
  
  void push (Atom *item);
  Atom *pop ();
  bool empty ();
  bool full ();
  void reset ();
  
  Atom **stack;
  long top;
  long last;
};

inline void
Stack::push (Atom *item)
{
  assert (top < last);
  stack[top] = item;
  top++;
}

inline Atom *
Stack::pop ()
{
  assert (top > 0);
  top--;
  return stack[top];
}

inline bool
Stack::empty ()
{
  return top == 0;
}

inline bool
Stack::full ()
{
  return top == last;
}

inline void
Stack::reset ()
{
  top = 0;
}

#endif
