// Copyright 1997 Patrik Simons
// This software is provided as is, no warranty of any kind is given.
//
// File:   list.h
// Author: Patrik Simons
//
#ifndef LIST_H
#define LIST_H

class Rule;
class Atom;
class Obj;

class Node
{
public:
  Node () { next = 0; ptr = 0; };
  ~Node () {};

  Node *next;
  union {
    Rule *rule;
    Atom *atom;
    Obj *ptr;
  };
};

class List
{
public:
  List ();
  ~List ();

  void push (Rule *);
  void push (Atom *);
  void push (Node *n);

  Node *head;
  Node *tail;
};

inline void
List::push (Node *n)
{
  if (head == 0)
    head = n;
  if (tail)
    tail->next = n;
  tail = n;
}

inline void
List::push (Rule *r)
{
  Node *n = new Node;
  n->rule = r;
  push (n);
}

inline void
List::push (Atom *a)
{
  Node *n = new Node;
  n->atom = a;
  push (n);
}

#endif
