// Copyright 1997 by Patrik Simons
// This software is provided as is, no warranty of any kind is given.
//
// File:   dcl.h
// Author: Patrik Simons
//
#ifndef DCL_H
#define DCL_H

class Atom;
class Program;
class Smodels;

class Dcl
{
public:
  Dcl (Smodels *s);
  ~Dcl ();
  void init ();
  void setup ();
  void revert ();
  void dcl ();
  int propagateFalse ();
  int path (Atom *a, Atom *b);
  void reduce (bool strongly);
  void unreduce ();
  void improve ();
  void unimprove ();
  void print ();

private:
  Smodels * const smodels;
  Program * const program;
  
  Atom **tmpfalse;
  long tmpfalsetop;
};

#endif
