// Copyright 1997 by Patrik Simons
// This software is provided as is, no warranty of any kind is given.
#ifndef API_H
#define API_H
#include "defines.h"

class Program;
class Atom;
class Tree;

class Api
{
public:
  Api (Program *);
  ~Api ();

  void begin_rule (RuleType);  // First call begin_rule
  void add_head (Atom *);      // Then call these
  void add_body (Atom *, bool pos);         // Add atom to body of rule
  void add_body (Atom *, bool pos, Weight); // Add atom with weight to body
  void change_body (long i, bool pos, Weight); // Change weight in body
  void set_atmost_weight (Weight);    // Weight rule
  void set_atleast_weight (Weight);   // Weight rule
  void set_atleast_body (long, bool); // Constraint rule
  void maximize_rule (bool);          // Optimize rule
  void end_rule ();            // Finally, end with end_rule

  Atom *new_atom ();        // Create new atom
  void set_compute (Atom *, bool);  // Compute statement
  void reset_compute (Atom *, bool);  // Compute statement
  void set_name (Atom *, const char *);
  void remember ();  // Remember the set_name calls after this
  void forget ();    // Forget the set_name calls after this
  Atom *get_atom (const char *); // get_atom only works for the
                                 // set_name calls that have
                                 // been remembered

  void done ();  // Call done after the program is completely defined
		 // and before you begin to compute

private:
  Program * const program;
  RuleType type;
  class list {
  public:
    list ();
    ~list ();
    void push (Atom *a, Weight w = 0);
    void reset ();
    void grow ();
    
    Atom **atoms;
    Weight *weights;
    int top;
    int size;
  };
  long size (list &);
  list pbody;
  list nbody;
  list head;
  Weight atleast_weight;
  Weight atmost_weight;
  long atleast_pos;
  long atleast_neg;
  bool maximize;
  Tree *tree;
  Tree *pointer_to_tree;
};

#endif
