/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* tree.h                    */
/* Burkhard Graves, 26.10.94 */
/*****************************/

#ifndef __TREE_H__
#define __TREE_H__

#include "main.h"

/*******************/
/* Typdefinitionen */
/*******************/

/*------------------------*/
/* Knoten des Syntaxbaums */
/*------------------------*/

typedef struct treenode {
    int info;                   /* Art des Knotens  */
    struct treenode *left;      /* linker Sohn      */
    struct treenode *right;     /* rechter Sohn     */
} TreeNode;

/**************/
/* Prototypen */
/**************/

TreeNode    *TreeCreateNode PROTO ((int info,TreeNode *left,TreeNode *right));
TreeNode          *TreeCopy PROTO ((TreeNode *node));
void             TreeDelete PROTO ((TreeNode *node));
void            TreeDisplay PROTO ((FILE *out,TreeNode *node));
TreeNode *DeliverSubformula PROTO ((TreeNode *node));
TreeNode    *DeliverDiamond PROTO ((TreeNode *node));
TreeNode *DeliverDiamOrQuan PROTO ((TreeNode *node));

#endif

/**********************/
/* END OF FILE tree.h */
/**********************/
