// Copyright 1997, 1998 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#ifndef BITARR_H
#define BITARR_H

#include "combi.h"

typedef unsigned long ARRAY_ITEM;    /* We could change this one to char if that
					speeds up some machines. */

typedef struct bit_array
{
    unsigned long numbits;           /* Number of bits stored in this
					bit-array. */
    unsigned long numitems;          /* The number of items used by array. */

    ARRAY_ITEM items[1];             /* This array is actually larger, the
					size of it is numwords. We save one
					pointer indirection in each access
					by doing it this way. */

} BITARRAY;


/* We try to make things portable and hope that
   the compiler will be smart enough to optimize
   the macros to more efficient ones. */

#define GetBit(array, index) \
    ((((array)->items[((unsigned long)(index)) / \
		      (sizeof(ARRAY_ITEM) * BITSPERBYTE)]) >> \
      (((unsigned long)(index)) % (sizeof(ARRAY_ITEM) * BITSPERBYTE))) & \
     ((ARRAY_ITEM)1)) \


#define SetBit(array, index) \
    (((array)->items[((unsigned long)(index)) / \
		     (sizeof(ARRAY_ITEM) * BITSPERBYTE)]) |= \
     (((ARRAY_ITEM)1) << (((unsigned long)(index)) % \
			  (sizeof(ARRAY_ITEM) * BITSPERBYTE)))) \

#define ClearBit(array, index) \
    (((array)->items[((unsigned long)(index)) / \
		     (sizeof(ARRAY_ITEM) * BITSPERBYTE)]) &= \
     ~(((ARRAY_ITEM)1) << (((unsigned long)(index)) % \
			   (sizeof(ARRAY_ITEM) * BITSPERBYTE)))) \

BITARRAY * CreateBitArray(unsigned long numbits);
void DeleteBitArray(BITARRAY * array);
#ifdef DEBUG
void DumpBitArray(BITARRAY * array,
		  unsigned, depth);
#endif
void BitArrayCopy(BITARRAY * source1,
		  BITARRAY * dest);
void BitArrayAnd(BITARRAY * source1,
		 BITARRAY * source2,
		 BITARRAY * dest);
void BitArrayOr(BITARRAY * source1,
		BITARRAY * source2,
		BITARRAY * dest);
void BitArrayNot(BITARRAY * source,
		 BITARRAY * dest);
void BitArrayNegateS1OrS2OverwriteS1(BITARRAY * source1,
				     BITARRAY * source2);

#endif BITARR_H
