// Copyright 2001 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#ifndef TREE2SMO_H
#define TREE2SMO_H

#include "tree.h"
#include "combi.h"
#include "smodels.h"
#include "api.h"
#include "set.h"
#include "ptnet.h"

TreeNode* PushNegationsIn(TreeNode *node, BOOL negate);
BOOL FormulaHasBoxOrRelease(TreeNode *node);
unsigned long Tree2Smo(TreeNode *node, unsigned long *formula_num, Api *api, unsigned long bound);
SET *GetVisiblePlaces(TreeNode *node, PTNet *net);
void AddVisiblePlaces(TreeNode *node, SET *set);
SET *GetVisibleTransitions(TreeNode *node, PTNet *net);

#endif /* TREE2SMO_H */

