// Copyright 1998 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#ifndef SHASH_H
#define SHASH_H

#include "combi.h"
#include "ulhash.h"

#define SIMPLE_HASH_DATA unsigned long

typedef struct simple_hash_table_item
{
  SIMPLE_HASH_DATA * data;           /* Actual data. */
  unsigned long signature;           /* Full hash signature to minimize key
					comparisons. If comparisons are
					cheap, remove this */
} SIMPLE_HASH_ITEM;

typedef struct simple_hash_table
{
    unsigned long array_items;       /* The number of items allocated. */
    unsigned long mask;              /* The mask used. */
    unsigned long max_items;         /* The max number of items used by array. */
    unsigned long num_items;         /* The number of items used by array. */
    SIMPLE_HASH_ITEM items[1];       /* This array is actually larger, the
					size of it is numwords. We save one
					pointer indirection in each access
					by doing it this way. */
} SIMPLEHASH;


SIMPLEHASH * CreateSimpleHash(unsigned long max_items);
void DeleteSimpleHash(SIMPLEHASH * hash);
void ClearSimpleHash(SIMPLEHASH * hash);
BOOL InsertDataTellIfNew(SIMPLEHASH * hash, SIMPLE_HASH_DATA * data);
SIMPLE_HASH_DATA * InsertDataIfNew(SIMPLEHASH * hash, SIMPLE_HASH_DATA * data);

#endif SHASH_H
