// Copyright 1998 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#ifndef UNF2SMO_H
#define UNF2SMO_H

#include "combi.h"
#include "braproc.h"

#include "smodels.h"
#include "atomrule.h"

class Unf2Smo
{
public:

  Unf2Smo(BraProcess *braproc);
  ~Unf2Smo();

  void SetOptimizeLevel(unsigned long optimize_level);
  void CreateDeadlockProgram(BOOL debugging);
  BOOL ComputeModel(void);
  BOOL CreateDeadlockConfiguration(void);
  void PrintProgram(void);
  void PrintStatistics(void);
  void PrintConfiguration(void);
  
  void InsertionSort(unsigned long n, unsigned long *a);
  void HeapSortRules(unsigned long m, unsigned long **rules);
  void RuleDownHeap(unsigned long ** rules,
		    unsigned long n,
		    unsigned long k);
  long RuleCompare(unsigned long *rule1,
		   unsigned long *rule2);
  unsigned long OptimizeRemoveSubAndSupersets(unsigned long num_rules,
					      unsigned long **rules,
					      BOOL supersets);

  BraProcess * braproc;
  Smodels * smodels;

  Atom * false_atom;
  Atom * live_atom;
  Atom * bottom_event_atom;
  Atom ** atoms;
  unsigned long num_atoms;
  
  unsigned long * events;
  unsigned long * blocked_events;
  unsigned long * replacement_events;
  unsigned long * conditions;

  BITARRAY * replaced_events;
  BITARRAY * current_configuration;
  
  BOOL optimize_remove_bottom_event;
  BOOL optimize_remove_conditions;
  BOOL optimize_remove_blocking;
  BOOL optimize_replace_conditions_by_events;
  BOOL optimize_replace_events_by_events;
  BOOL optimize_use_choice_rules;
  BOOL optimize_use_deadlock_property;
  
  BOOL optimize_remove_duplicate_rules;
  BOOL optimize_sort_rules;
  BOOL optimize_remove_sub_and_supersets;
};

#endif UNF2SMO_H
