// Copyright 1998 by Patrik Simons
// This software is provided as is, no warranty of any kind is given.
#ifndef STABLE_H
#define STABLE_H

#include "smodels.h"
#include "read.h"
#include "timer.h"

class Stable
{
public:
  Stable ();
  virtual ~Stable ();
  
  int read (istream &f);
  int tries (bool lookahead, bool backjumping, long max_conflicts,
	     long max_tries, long seed);
  void calculate (bool w, bool lookahead, bool backjumping,
		  bool sloppy_heuristic = false,
		  long max_conflicts = 0, long max_tries = 1,
		  long seed = 1);

  Smodels smodels;
  Read reader;
  Timer timer;
};

#endif
